/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.DBUtil;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.cpi.CredentialStoreService;
import org.apache.airavata.credential.store.credential.Credential;
import org.apache.airavata.credential.store.credential.CredentialOwnerType;
import org.apache.airavata.credential.store.credential.impl.ssh.SSHCredential;
import org.apache.airavata.credential.store.exception.CredentialStoreException;
import org.apache.airavata.credential.store.store.impl.CertificateCredentialWriter;
import org.apache.airavata.credential.store.store.impl.CredentialReaderImpl;
import org.apache.airavata.credential.store.store.impl.SSHCredentialWriter;
import org.apache.airavata.credential.store.store.impl.util.CredentialStoreInitUtil;
import org.apache.airavata.credential.store.util.TokenGenerator;
import org.apache.airavata.credential.store.util.Utility;
import org.apache.airavata.model.credential.store.CertificateCredential;
import org.apache.airavata.model.credential.store.CommunityUser;
import org.apache.airavata.model.credential.store.CredentialSummary;
import org.apache.airavata.model.credential.store.PasswordCredential;
import org.apache.airavata.model.credential.store.SummaryType;
import org.apache.commons.codec.binary.Base64;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialStoreServerHandler
implements CredentialStoreService.Iface {
    protected static Logger log = LoggerFactory.getLogger(CredentialStoreServerHandler.class);
    private DBUtil dbUtil;
    private SSHCredentialWriter sshCredentialWriter;
    private CertificateCredentialWriter certificateCredentialWriter;
    private CredentialReaderImpl credentialReader;

    public CredentialStoreServerHandler() throws ApplicationSettingsException, IllegalAccessException, ClassNotFoundException, InstantiationException, SQLException, IOException {
        String jdbcUrl = ServerSettings.getCredentialStoreDBURL();
        String userName = ServerSettings.getCredentialStoreDBUser();
        String password = ServerSettings.getCredentialStoreDBPassword();
        String driverName = ServerSettings.getCredentialStoreDBDriver();
        log.debug("Starting credential store, connecting to database - " + jdbcUrl + " DB user - " + userName + " driver name - " + driverName);
        CredentialStoreInitUtil.initializeDB();
        this.dbUtil = new DBUtil(jdbcUrl, userName, password, driverName);
        this.sshCredentialWriter = new SSHCredentialWriter(this.dbUtil);
        this.certificateCredentialWriter = new CertificateCredentialWriter(this.dbUtil);
        this.credentialReader = new CredentialReaderImpl(this.dbUtil);
    }

    public String getCSServiceVersion() throws TException {
        return "0.16.0";
    }

    public String addSSHCredential(org.apache.airavata.model.credential.store.SSHCredential sshCredential) throws CredentialStoreException, TException {
        try {
            SSHCredential credential = new SSHCredential();
            credential.setGateway(sshCredential.getGatewayId());
            credential.setPortalUserName(sshCredential.getUsername());
            String token = TokenGenerator.generateToken(sshCredential.getGatewayId(), null);
            credential.setToken(token);
            credential.setPassphrase(String.valueOf(UUID.randomUUID()));
            if (sshCredential.getPrivateKey() != null) {
                credential.setPrivateKey(sshCredential.getPrivateKey().getBytes());
            }
            if (sshCredential.getDescription() != null) {
                credential.setDescription(sshCredential.getDescription());
            }
            if (sshCredential.getPublicKey() != null) {
                credential.setPublicKey(sshCredential.getPublicKey().getBytes());
            }
            if (sshCredential.getPublicKey() == null || sshCredential.getPrivateKey() == null) {
                credential = Utility.generateKeyPair(credential);
            }
            credential.setCredentialOwnerType(CredentialOwnerType.findByDataModelType(sshCredential.getCredentialOwnerType()));
            this.sshCredentialWriter.writeCredentials(credential);
            return token;
        }
        catch (org.apache.airavata.credential.store.store.CredentialStoreException e) {
            log.error("Error occurred while saving SSH Credentials.", (Throwable)e);
            throw new CredentialStoreException("Error occurred while saving SSH Credentials.");
        }
        catch (Exception e) {
            log.error("Error occurred while generating key pair.", (Throwable)e);
            throw new CredentialStoreException("Error occurred while generating key pair..");
        }
    }

    public String addCertificateCredential(CertificateCredential certificateCredential) throws CredentialStoreException, TException {
        try {
            org.apache.airavata.credential.store.credential.impl.certificate.CertificateCredential credential = new org.apache.airavata.credential.store.credential.impl.certificate.CertificateCredential();
            credential.setPortalUserName(certificateCredential.getCommunityUser().getUsername());
            credential.setCommunityUser(new org.apache.airavata.credential.store.credential.CommunityUser(certificateCredential.getCommunityUser().getGatewayName(), certificateCredential.getCommunityUser().getUsername(), certificateCredential.getCommunityUser().getUserEmail()));
            String token = TokenGenerator.generateToken(certificateCredential.getCommunityUser().getGatewayName(), null);
            credential.setToken(token);
            Base64 encoder = new Base64(64);
            byte[] decoded = encoder.decode(certificateCredential.getX509Cert().replaceAll("-----BEGIN CERTIFICATE-----", "").replaceAll("-----END CERTIFICATE-----", ""));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(decoded));
            X509Certificate[] certificates = new X509Certificate[]{certificate};
            credential.setCertificates(certificates);
            this.certificateCredentialWriter.writeCredentials(credential);
            return token;
        }
        catch (org.apache.airavata.credential.store.store.CredentialStoreException e) {
            log.error("Error occurred while saving Certificate Credentials.", (Throwable)e);
            throw new CredentialStoreException("Error occurred while saving Certificate Credentials.");
        }
        catch (Exception e) {
            log.error("Error occurred while converting to X509 certificate.", (Throwable)e);
            throw new CredentialStoreException("Error occurred while converting to X509 certificate..");
        }
    }

    public String addPasswordCredential(PasswordCredential passwordCredential) throws CredentialStoreException, TException {
        try {
            org.apache.airavata.credential.store.credential.impl.password.PasswordCredential credential = new org.apache.airavata.credential.store.credential.impl.password.PasswordCredential();
            credential.setGateway(passwordCredential.getGatewayId());
            credential.setPortalUserName(passwordCredential.getPortalUserName());
            credential.setUserName(passwordCredential.getLoginUserName());
            credential.setPassword(passwordCredential.getPassword());
            credential.setDescription(passwordCredential.getDescription());
            String token = TokenGenerator.generateToken(passwordCredential.getGatewayId(), null);
            credential.setToken(token);
            this.sshCredentialWriter.writeCredentials(credential);
            return token;
        }
        catch (org.apache.airavata.credential.store.store.CredentialStoreException e) {
            log.error("Error occurred while saving PWD Credentials.", (Throwable)e);
            throw new CredentialStoreException("Error occurred while saving PWD Credentials.");
        }
        catch (Exception e) {
            log.error("Error occurred while registering PWD Credentials.", (Throwable)e);
            throw new CredentialStoreException("Error occurred while registering PWD Credentials..");
        }
    }

    public org.apache.airavata.model.credential.store.SSHCredential getSSHCredential(String tokenId, String gatewayId) throws CredentialStoreException, TException {
        try {
            Credential credential = this.credentialReader.getCredential(gatewayId, tokenId);
            if (credential instanceof SSHCredential) {
                SSHCredential credential1 = (SSHCredential)credential;
                org.apache.airavata.model.credential.store.SSHCredential sshCredential = new org.apache.airavata.model.credential.store.SSHCredential();
                sshCredential.setUsername(credential1.getPortalUserName());
                sshCredential.setGatewayId(credential1.getGateway());
                sshCredential.setPublicKey(new String(credential1.getPublicKey()));
                sshCredential.setPrivateKey(new String(credential1.getPrivateKey()));
                sshCredential.setPassphrase(credential1.getPassphrase());
                sshCredential.setToken(credential1.getToken());
                sshCredential.setPersistedTime(credential1.getCertificateRequestedTime().getTime());
                sshCredential.setDescription(credential1.getDescription());
                sshCredential.setCredentialOwnerType(credential1.getCredentialOwnerType().getDatamodelType());
                return sshCredential;
            }
            log.info("Could not find SSH credentials for token - " + tokenId + " and gateway id - " + gatewayId);
            return null;
        }
        catch (org.apache.airavata.credential.store.store.CredentialStoreException e) {
            log.error("Error occurred while retrieving SSH credentialfor token - " + tokenId + " and gateway id - " + gatewayId, (Throwable)e);
            throw new CredentialStoreException("Error occurred while retrieving SSH credential for token - " + tokenId + " and gateway id - " + gatewayId);
        }
    }

    public CredentialSummary getCredentialSummary(SummaryType type, String tokenId, String gatewayId) throws CredentialStoreException, TException {
        try {
            if (type.equals((Object)SummaryType.SSH)) {
                Credential credential = this.credentialReader.getCredential(gatewayId, tokenId);
                if (credential instanceof SSHCredential) {
                    SSHCredential credential1 = (SSHCredential)credential;
                    CredentialSummary sshCredentialSummary = new CredentialSummary();
                    sshCredentialSummary.setType(SummaryType.SSH);
                    sshCredentialSummary.setUsername(credential1.getPortalUserName());
                    sshCredentialSummary.setGatewayId(credential1.getGateway());
                    sshCredentialSummary.setPublicKey(new String(credential1.getPublicKey()));
                    sshCredentialSummary.setToken(credential1.getToken());
                    sshCredentialSummary.setPersistedTime(credential1.getCertificateRequestedTime().getTime());
                    sshCredentialSummary.setDescription(credential1.getDescription());
                    return sshCredentialSummary;
                }
                log.info("Could not find SSH credential for token - " + tokenId + " and gateway id - " + gatewayId);
                return null;
            }
            log.info("Summay Type" + type.toString() + " not supported for - " + tokenId + " and gateway id - " + gatewayId);
            return null;
        }
        catch (org.apache.airavata.credential.store.store.CredentialStoreException e) {
            log.error("Error occurred while retrieving SSH credential Summary for token - " + tokenId + " and gateway id - " + gatewayId, (Throwable)e);
            throw new CredentialStoreException("Error occurred while retrieving SSH credential Summary for token - " + tokenId + " and gateway id - " + gatewayId);
        }
    }

    public CertificateCredential getCertificateCredential(String tokenId, String gatewayId) throws CredentialStoreException, TException {
        try {
            Credential credential = this.credentialReader.getCredential(gatewayId, tokenId);
            if (credential instanceof org.apache.airavata.credential.store.credential.impl.certificate.CertificateCredential) {
                org.apache.airavata.credential.store.credential.impl.certificate.CertificateCredential credential1 = (org.apache.airavata.credential.store.credential.impl.certificate.CertificateCredential)credential;
                CertificateCredential certificateCredential = new CertificateCredential();
                CommunityUser communityUser = new CommunityUser();
                communityUser.setGatewayName(credential1.getCommunityUser().getGatewayName());
                communityUser.setUsername(credential1.getCommunityUser().getUserName());
                communityUser.setUserEmail(credential1.getCommunityUser().getUserEmail());
                certificateCredential.setCommunityUser(communityUser);
                certificateCredential.setToken(credential1.getToken());
                certificateCredential.setLifeTime(credential1.getLifeTime());
                certificateCredential.setNotAfter(credential1.getNotAfter());
                certificateCredential.setNotBefore(credential1.getNotBefore());
                certificateCredential.setPersistedTime(credential1.getCertificateRequestedTime().getTime());
                if (credential1.getPrivateKey() != null) {
                    certificateCredential.setPrivateKey(credential1.getPrivateKey().toString());
                }
                certificateCredential.setX509Cert(credential1.getCertificates()[0].toString());
                return certificateCredential;
            }
            log.info("Could not find Certificate credentials for token - " + tokenId + " and gateway id - " + gatewayId);
            return null;
        }
        catch (org.apache.airavata.credential.store.store.CredentialStoreException e) {
            log.error("Error occurred while retrieving Certificate credential for token - " + tokenId + " and gateway id - " + gatewayId, (Throwable)e);
            throw new CredentialStoreException("Error occurred while retrieving Certificate credential for token - " + tokenId + " and gateway id - " + gatewayId);
        }
    }

    public PasswordCredential getPasswordCredential(String tokenId, String gatewayId) throws CredentialStoreException, TException {
        try {
            Credential credential = this.credentialReader.getCredential(gatewayId, tokenId);
            if (credential instanceof org.apache.airavata.credential.store.credential.impl.password.PasswordCredential) {
                org.apache.airavata.credential.store.credential.impl.password.PasswordCredential credential1 = (org.apache.airavata.credential.store.credential.impl.password.PasswordCredential)credential;
                PasswordCredential pwdCredential = new PasswordCredential();
                pwdCredential.setGatewayId(credential1.getGateway());
                pwdCredential.setPortalUserName(credential1.getPortalUserName());
                pwdCredential.setLoginUserName(credential1.getUserName());
                pwdCredential.setPassword(credential1.getPassword());
                pwdCredential.setDescription(credential1.getDescription());
                pwdCredential.setToken(credential1.getToken());
                pwdCredential.setPersistedTime(credential1.getCertificateRequestedTime().getTime());
                return pwdCredential;
            }
            log.info("Could not find PWD credentials for token - " + tokenId + " and gateway id - " + gatewayId);
            return null;
        }
        catch (org.apache.airavata.credential.store.store.CredentialStoreException e) {
            log.error("Error occurred while retrieving PWD credentialfor token - " + tokenId + " and gateway id - " + gatewayId, (Throwable)e);
            throw new CredentialStoreException("Error occurred while retrieving PWD credential for token - " + tokenId + " and gateway id - " + gatewayId);
        }
    }

    public Map<String, String> getAllSSHKeysForUser(String username) throws CredentialStoreException, TException {
        HashMap<String, String> sshKeyMap = new HashMap<String, String>();
        try {
            List<Credential> allCredentials = this.credentialReader.getAllCredentials();
            if (allCredentials != null && !allCredentials.isEmpty()) {
                for (Credential credential : allCredentials) {
                    byte[] publicKey;
                    SSHCredential sshCredential;
                    String portalUserName;
                    if (!(credential instanceof SSHCredential) || (portalUserName = (sshCredential = (SSHCredential)credential).getPortalUserName()) == null || sshCredential.getCredentialOwnerType() != CredentialOwnerType.USER || !portalUserName.equals(username) || (publicKey = sshCredential.getPublicKey()) == null) continue;
                    sshKeyMap.put(sshCredential.getToken(), new String(publicKey));
                }
            }
        }
        catch (org.apache.airavata.credential.store.store.CredentialStoreException e) {
            log.error("Error occurred while retrieving credentials", (Throwable)e);
            throw new CredentialStoreException("Error occurred while retrieving credentials");
        }
        return sshKeyMap;
    }

    public Map<String, String> getAllSSHKeysForGateway(String gatewayId) throws CredentialStoreException, TException {
        HashMap<String, String> sshKeyMap = new HashMap<String, String>();
        try {
            List<Credential> allCredentials = this.credentialReader.getAllCredentialsPerGateway(gatewayId);
            if (allCredentials != null && !allCredentials.isEmpty()) {
                for (Credential credential : allCredentials) {
                    SSHCredential sshCredential;
                    byte[] publicKey;
                    if (!(credential instanceof SSHCredential) || (publicKey = (sshCredential = (SSHCredential)credential).getPublicKey()) == null || sshCredential.getCredentialOwnerType() != CredentialOwnerType.GATEWAY) continue;
                    sshKeyMap.put(sshCredential.getToken(), new String(publicKey));
                }
            }
        }
        catch (org.apache.airavata.credential.store.store.CredentialStoreException e) {
            log.error("Error occurred while retrieving credentials", (Throwable)e);
            throw new CredentialStoreException("Error occurred while retrieving credentials");
        }
        return sshKeyMap;
    }

    public List<CredentialSummary> getAllCredentialSummaryForGateway(SummaryType type, String gatewayId) throws CredentialStoreException, TException {
        if (type.equals((Object)SummaryType.SSH)) {
            HashMap sshKeyMap = new HashMap();
            ArrayList<CredentialSummary> summaryList = new ArrayList<CredentialSummary>();
            try {
                List<Credential> allCredentials = this.credentialReader.getAllCredentialsPerGateway(gatewayId);
                if (allCredentials != null && !allCredentials.isEmpty()) {
                    for (Credential credential : allCredentials) {
                        if (!(credential instanceof SSHCredential) || credential.getCredentialOwnerType() != CredentialOwnerType.GATEWAY) continue;
                        SSHCredential sshCredential = (SSHCredential)credential;
                        CredentialSummary sshCredentialSummary = new CredentialSummary();
                        sshCredentialSummary.setType(SummaryType.SSH);
                        sshCredentialSummary.setToken(sshCredential.getToken());
                        sshCredentialSummary.setUsername(sshCredential.getPortalUserName());
                        sshCredentialSummary.setGatewayId(sshCredential.getGateway());
                        sshCredentialSummary.setDescription(sshCredential.getDescription());
                        sshCredentialSummary.setPublicKey(new String(sshCredential.getPublicKey()));
                        summaryList.add(sshCredentialSummary);
                    }
                }
            }
            catch (org.apache.airavata.credential.store.store.CredentialStoreException e) {
                log.error("Error occurred while retrieving credential Summary", (Throwable)e);
                throw new CredentialStoreException("Error occurred while retrieving credential Summary");
            }
            return summaryList;
        }
        log.info("Summay Type" + type.toString() + " not supported for gateway id - " + gatewayId);
        return null;
    }

    public List<CredentialSummary> getAllCredentialSummaryForUserInGateway(SummaryType type, String gatewayId, String userId) throws CredentialStoreException, TException {
        if (type.equals((Object)SummaryType.SSH)) {
            HashMap sshKeyMap = new HashMap();
            ArrayList<CredentialSummary> summaryList = new ArrayList<CredentialSummary>();
            try {
                List<Credential> allCredentials = this.credentialReader.getAllCredentials();
                if (allCredentials != null && !allCredentials.isEmpty()) {
                    for (Credential credential : allCredentials) {
                        if (!(credential instanceof SSHCredential)) continue;
                        SSHCredential sshCredential = (SSHCredential)credential;
                        String portalUserName = sshCredential.getPortalUserName();
                        String gateway = sshCredential.getGateway();
                        if (portalUserName == null || gateway == null || !portalUserName.equals(userId) || !gateway.equals(gatewayId) || sshCredential.getCredentialOwnerType() != CredentialOwnerType.USER) continue;
                        SSHCredential sshCredentialKey = (SSHCredential)credential;
                        CredentialSummary sshCredentialSummary = new CredentialSummary();
                        sshCredentialSummary.setType(SummaryType.SSH);
                        sshCredentialSummary.setToken(sshCredentialKey.getToken());
                        sshCredentialSummary.setUsername(sshCredentialKey.getPortalUserName());
                        sshCredentialSummary.setGatewayId(sshCredentialKey.getGateway());
                        sshCredentialSummary.setDescription(sshCredentialKey.getDescription());
                        sshCredentialSummary.setPublicKey(new String(sshCredentialKey.getPublicKey()));
                        summaryList.add(sshCredentialSummary);
                    }
                }
            }
            catch (org.apache.airavata.credential.store.store.CredentialStoreException e) {
                log.error("Error occurred while retrieving credential Summary", (Throwable)e);
                throw new CredentialStoreException("Error occurred while retrieving credential Summary");
            }
            return summaryList;
        }
        log.info("Summay Type" + type.toString() + " not supported for user Id - " + userId + " and gateway id - " + gatewayId);
        return null;
    }

    public Map<String, String> getAllPWDCredentialsForGateway(String gatewayId) throws CredentialStoreException, TException {
        HashMap<String, String> pwdCredMap = new HashMap<String, String>();
        try {
            List<Credential> allCredentials = this.credentialReader.getAllCredentialsPerGateway(gatewayId);
            if (allCredentials != null && !allCredentials.isEmpty()) {
                for (Credential credential : allCredentials) {
                    if (!(credential instanceof org.apache.airavata.credential.store.credential.impl.password.PasswordCredential)) continue;
                    org.apache.airavata.credential.store.credential.impl.password.PasswordCredential pwdCredential = (org.apache.airavata.credential.store.credential.impl.password.PasswordCredential)credential;
                    pwdCredMap.put(pwdCredential.getToken(), pwdCredential.getDescription() == null ? "" : pwdCredential.getDescription());
                }
            }
        }
        catch (org.apache.airavata.credential.store.store.CredentialStoreException e) {
            log.error("Error occurred while retrieving credentials", (Throwable)e);
            throw new CredentialStoreException("Error occurred while retrieving credentials");
        }
        return pwdCredMap;
    }

    public boolean deleteSSHCredential(String tokenId, String gatewayId) throws CredentialStoreException, TException {
        try {
            this.credentialReader.removeCredentials(gatewayId, tokenId);
            return true;
        }
        catch (org.apache.airavata.credential.store.store.CredentialStoreException e) {
            log.error("Error occurred while deleting SSH credential for token - " + tokenId + " and gateway id - " + gatewayId, (Throwable)e);
            throw new CredentialStoreException("Error occurred while deleting SSH credential for token - " + tokenId + " and gateway id - " + gatewayId);
        }
    }

    public boolean deletePWDCredential(String tokenId, String gatewayId) throws CredentialStoreException, TException {
        try {
            this.credentialReader.removeCredentials(gatewayId, tokenId);
            return true;
        }
        catch (org.apache.airavata.credential.store.store.CredentialStoreException e) {
            log.error("Error occurred while deleting PWD credential for token - " + tokenId + " and gateway id - " + gatewayId, (Throwable)e);
            throw new CredentialStoreException("Error occurred while deleting PWD credential for token - " + tokenId + " and gateway id - " + gatewayId);
        }
    }
}

