/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.core;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GFacThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(GFacThreadPoolExecutor.class);
    public static final String GFAC_THREAD_POOL_SIZE = "gfac.thread.pool.size";
    private static ExecutorService threadPool;

    public static ExecutorService getCachedThreadPool() {
        if (threadPool == null) {
            threadPool = Executors.newCachedThreadPool();
        }
        return threadPool;
    }

    public static ExecutorService client() throws ApplicationSettingsException {
        if (threadPool == null) {
            try {
                threadPool = Executors.newFixedThreadPool(Integer.parseInt(ServerSettings.getSetting((String)GFAC_THREAD_POOL_SIZE)));
            }
            catch (ApplicationSettingsException e) {
                logger.error("Error reading gfac.thread.pool.size property");
                throw e;
            }
        }
        return threadPool;
    }
}

