/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.cache;

import edu.uiuc.ncsa.security.core.cache.Cache;
import edu.uiuc.ncsa.security.core.cache.RetentionPolicy;
import edu.uiuc.ncsa.security.core.exceptions.InvalidTimestampException;
import edu.uiuc.ncsa.security.core.util.DateUtils;

public class ValidTimestampPolicy
implements RetentionPolicy {
    protected long maxTimeout = -1L;

    public ValidTimestampPolicy(long maxTimeout) {
        this.maxTimeout = maxTimeout;
    }

    public ValidTimestampPolicy() {
    }

    @Override
    public boolean applies() {
        return true;
    }

    public boolean retain(Object key, Object value) {
        try {
            if (this.maxTimeout <= 0L) {
                DateUtils.checkTimestamp(key.toString());
            } else {
                DateUtils.checkTimestamp(key.toString(), this.maxTimeout);
            }
            return true;
        }
        catch (InvalidTimestampException its) {
            return false;
        }
    }

    public Cache getMap() {
        return null;
    }
}

