/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.dpc;

import eu.unicore.uftp.client.ClientAuthenticator;
import eu.unicore.uftp.dpc.AuthorizationFailureException;
import eu.unicore.uftp.dpc.DPCServer;
import eu.unicore.uftp.dpc.ProtocolViolationException;
import eu.unicore.uftp.dpc.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class DPCClient {
    private static final Logger logger = Logger.getLogger(DPCClient.class);
    private int timeout;
    private int authTimeout;
    private Socket controlSocket;
    private Socket[] dataSockets = null;
    private volatile boolean connected = false;
    private BufferedWriter controlWriter;
    private BufferedReader controlReader;
    protected static final String[] requests = new String[]{"USER anonymous", "USER anonymous", "SYST"};

    public void connect(InetAddress[] server, int port, ClientAuthenticator auth) throws IOException, AuthorizationFailureException {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        InetAddress selectedServer = null;
        StringBuilder errors = new StringBuilder();
        int tries = 0;
        ArrayList<InetAddress> servers = new ArrayList<InetAddress>();
        servers.addAll(Arrays.asList(server));
        block5: while (servers.size() > 0 && tries < 3) {
            int currentTimeoutValue = ++tries * this.timeout;
            Iterator iter = servers.iterator();
            while (iter.hasNext()) {
                InetAddress s = (InetAddress)iter.next();
                try {
                    this.controlSocket = new Socket();
                    this.controlSocket.connect(new InetSocketAddress(s, port), currentTimeoutValue);
                    selectedServer = s;
                    break block5;
                }
                catch (SocketTimeoutException ste) {
                }
                catch (Exception ex) {
                    iter.remove();
                    try {
                        if (this.controlSocket != null) {
                            this.controlSocket.close();
                        }
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    errors.append("[").append(s).append(": ").append(Utils.createFaultMessage(s.toString(), ex)).append("]");
                }
            }
        }
        if (selectedServer == null) {
            throw new IOException("Can't connect to server(s) " + Arrays.asList(server) + " at port " + port + ". Error message " + errors);
        }
        logger.info("Authenticating to UFTP server at IP: " + selectedServer.getHostAddress() + " port: " + port);
        this.establishConnection(auth);
        logger.info("Connection established.");
    }

    private void establishConnection(ClientAuthenticator auth) throws IOException, AuthorizationFailureException {
        this.controlWriter = new BufferedWriter(new OutputStreamWriter(this.controlSocket.getOutputStream()));
        this.controlReader = new BufferedReader(new InputStreamReader(this.controlSocket.getInputStream()));
        this.initialHandshake();
        this.pseudoLogin();
        List<String> features = this.readFeatures();
        DPCClient.checkPassivSupport(features);
        this.authenticate(auth);
        this.connected = true;
    }

    public Socket[] openDataConnections(int numParCons) throws IOException {
        this.checkConnected();
        logger.info("Creating parallel socket with " + numParCons + " streams.");
        if (this.dataSockets != null) {
            throw new IllegalStateException("There are already open data connections.");
        }
        String noopMsg = "NOOP " + numParCons + "\r\n";
        this.controlWriter.write(noopMsg);
        this.controlWriter.flush();
        logger.debug("--> " + noopMsg);
        String noopResponse = this.controlReader.readLine();
        if (noopResponse.startsWith("223")) {
            numParCons = Integer.parseInt(noopResponse.split(" ")[2]);
        }
        logger.debug(noopResponse);
        this.dataSockets = new Socket[numParCons];
        for (int i = 0; i < this.dataSockets.length; ++i) {
            this.dataSockets[i] = this.getNewConnection();
        }
        return this.dataSockets;
    }

    private void initialHandshake() throws IOException {
        String response = this.readControl();
        if (response == null) {
            throw new IOException("The connection was refused by the UFTPD server. Please check the client IP and other parameters.");
        }
        if (!response.startsWith("220")) {
            throw new ProtocolViolationException("Code '220' expected, got " + response);
        }
    }

    private void pseudoLogin() throws IOException {
        for (int i = 0; i < requests.length; ++i) {
            this.sendControl(requests[i]);
            String response = this.readControl();
            if (DPCServer.responses[i + 1].equals(response)) continue;
            String err = "'" + response + "' does not comply with protocol.";
            this.sendControl("500 " + err);
            throw new ProtocolViolationException(err);
        }
    }

    private List<String> readFeatures() throws IOException {
        ArrayList<String> features = new ArrayList<String>();
        this.sendControl("FEAT");
        String response = this.readControl();
        if (!response.startsWith("211")) {
            throw new ProtocolViolationException("Expected 211 reply.");
        }
        while (true) {
            if ((response = this.readControl()) == null || features.size() > 21) {
                throw new ProtocolViolationException("Illegal server reply: too many features");
            }
            if ("211 END".equals(response)) break;
            features.add(response.trim());
        }
        return features;
    }

    private Socket getNewConnection() throws IOException {
        this.sendControl("PASV");
        String inputLine = this.readControl();
        String[] inputString = inputLine.split(" ")[4].substring(1).split(",");
        InetAddress dataAddress = InetAddress.getByName(inputString[0] + "." + inputString[1] + "." + inputString[2] + "." + inputString[3]);
        int dataPort = Integer.parseInt(inputString[4]) * 256 + Integer.parseInt(inputString[5].substring(0, inputString[5].length() - 1));
        return new Socket(dataAddress, dataPort);
    }

    public void closeData() throws IOException {
        for (Socket dataSocket : this.dataSockets) {
            dataSocket.close();
        }
        this.dataSockets = null;
    }

    public void close() throws IOException {
        this.closeData();
        this.controlSocket.close();
        this.connected = false;
        logger.info("Connection closed.");
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getAuthTimeout() {
        return this.authTimeout;
    }

    public void setAuthTimeout(int authTimeout) {
        this.authTimeout = authTimeout;
    }

    public void sendControl(String message) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("--> " + message.trim());
        }
        this.controlWriter.write(message + "\r\n");
        this.controlWriter.flush();
    }

    public String readControl() throws IOException {
        String res = this.controlReader.readLine();
        if (logger.isDebugEnabled()) {
            logger.debug("<-- " + res.trim());
        }
        return res;
    }

    private void checkConnected() {
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
    }

    private static void checkPassivSupport(List<String> features) throws ProtocolViolationException {
        if (features == null || features.isEmpty() || !"PASV".equals(features.get(0))) {
            throw new ProtocolViolationException("Illegal server reply, missing PASV feature");
        }
    }

    private void authenticate(ClientAuthenticator auth) throws IOException, AuthorizationFailureException {
        Socket authSocket = this.getNewConnection();
        auth.authenticate(authSocket);
        authSocket.close();
    }
}

