/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.io.IOException;
import java.util.Calendar;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.COSObjectable;

public class PDDocumentInformation
implements COSObjectable {
    private static final COSName TITLE = COSName.getPDFName("Title");
    private static final COSName AUTHOR = COSName.getPDFName("Author");
    private static final COSName SUBJECT = COSName.getPDFName("Subject");
    private static final COSName KEYWORDS = COSName.getPDFName("Keywords");
    private static final COSName CREATOR = COSName.getPDFName("Creator");
    private static final COSName PRODUCER = COSName.getPDFName("Producer");
    private static final COSName CREATION_DATE = COSName.getPDFName("CreationDate");
    private static final COSName MODIFICATION_DATE = COSName.getPDFName("ModDate");
    private static final COSName TRAPPED = COSName.getPDFName("Trapped");
    private COSDictionary info;

    public PDDocumentInformation() {
        this.info = new COSDictionary();
    }

    public PDDocumentInformation(COSDictionary dic) {
        this.info = dic;
    }

    public COSDictionary getDictionary() {
        return this.info;
    }

    public COSBase getCOSObject() {
        return this.info;
    }

    public String getTitle() {
        return this.info.getString(TITLE);
    }

    public void setTitle(String title) {
        this.info.setString(TITLE, title);
    }

    public String getAuthor() {
        return this.info.getString(AUTHOR);
    }

    public void setAuthor(String author) {
        this.info.setString(AUTHOR, author);
    }

    public String getSubject() {
        return this.info.getString(SUBJECT);
    }

    public void setSubject(String subject) {
        this.info.setString(SUBJECT, subject);
    }

    public String getKeywords() {
        return this.info.getString(KEYWORDS);
    }

    public void setKeywords(String keywords) {
        this.info.setString(KEYWORDS, keywords);
    }

    public String getCreator() {
        return this.info.getString(CREATOR);
    }

    public void setCreator(String creator) {
        this.info.setString(CREATOR, creator);
    }

    public String getProducer() {
        return this.info.getString(PRODUCER);
    }

    public void setProducer(String producer) {
        this.info.setString(PRODUCER, producer);
    }

    public Calendar getCreationDate() throws IOException {
        return this.info.getDate(CREATION_DATE);
    }

    public void setCreationDate(Calendar date) {
        this.info.setDate(CREATION_DATE, date);
    }

    public Calendar getModificationDate() throws IOException {
        return this.info.getDate(MODIFICATION_DATE);
    }

    public void setModificationDate(Calendar date) {
        this.info.setDate(MODIFICATION_DATE, date);
    }

    public String getTrapped() {
        return this.info.getNameAsString(TRAPPED);
    }

    public String getCustomMetadataValue(String fieldName) {
        return this.info.getString(fieldName);
    }

    public void setCustomMetadataValue(String fieldName, String fieldValue) {
        this.info.setString(fieldName, fieldValue);
    }

    public void setTrapped(String value) {
        if (!(value == null || value.equals("True") || value.equals("False") || value.equals("Unknown"))) {
            throw new RuntimeException("Valid values for trapped are 'True', 'False', or 'Unknown'");
        }
        this.info.setName(TRAPPED, value);
    }
}

