/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jpa.entities;

import java.util.ArrayList;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.mapping.ResourceMapping;
import org.compass.gps.device.jpa.JpaGpsDevice;
import org.compass.gps.device.jpa.JpaGpsDeviceException;
import org.compass.gps.device.jpa.entities.EntityInformation;
import org.compass.gps.device.jpa.entities.JpaEntitiesLocator;
import org.compass.gps.spi.CompassGpsInterfaceDevice;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.sessions.server.ServerSession;

public class EclipseLinkJpaEntitiesLocator
implements JpaEntitiesLocator {
    protected Log log = LogFactory.getLog(this.getClass());

    public EntityInformation[] locate(EntityManagerFactory entityManagerFactory, JpaGpsDevice device) throws JpaGpsDeviceException {
        CompassGpsInterfaceDevice gps = (CompassGpsInterfaceDevice)device.getGps();
        JpaEntityManager entityManager = (JpaEntityManager)entityManagerFactory.createEntityManager();
        ServerSession session = entityManager.getServerSession();
        entityManager.close();
        ArrayList<EntityInformation> entitiesList = new ArrayList<EntityInformation>();
        Map descriptors = session.getDescriptors();
        for (Object o : descriptors.values()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)o;
            String entityname = classDescriptor.getJavaClassName();
            if (!gps.hasMappingForEntityForIndex(entityname)) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Entity [" + entityname + "] does not have compass mapping, filtering it out"));
                continue;
            }
            if (this.shouldFilter(entityname, classDescriptor, device)) continue;
            Class clazz = classDescriptor.getJavaClass();
            ResourceMapping resourceMapping = gps.getMappingForEntityForIndex(entityname);
            EntityInformation entityInformation = new EntityInformation(clazz, classDescriptor.getAlias(), resourceMapping.getSubIndexHash().getSubIndexes());
            entitiesList.add(entityInformation);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Entity [" + entityname + "] will be indexed"));
        }
        return entitiesList.toArray(new EntityInformation[entitiesList.size()]);
    }

    protected boolean shouldFilter(String entityname, ClassDescriptor classDescriptor, JpaGpsDevice device) {
        if (!classDescriptor.hasInheritance()) {
            return false;
        }
        InheritancePolicy inheritancePolicy = classDescriptor.getInheritancePolicy();
        if (inheritancePolicy == null || inheritancePolicy.getParentClass() == null) {
            return false;
        }
        Class superClass = inheritancePolicy.getParentClass();
        if (superClass != null && ((CompassGpsInterfaceDevice)device.getGps()).hasMappingForEntityForIndex(superClass)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Entity [" + entityname + "] is inherited and super class [" + superClass + "] has compass mapping, filtering it out"));
            }
            return true;
        }
        return false;
    }
}

