/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.replica.catalog.model;

import java.sql.Timestamp;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.airavata.registry.core.replica.catalog.model.DataProductMetaData;
import org.apache.airavata.registry.core.replica.catalog.model.DataReplicaLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="DATA_PRODUCT")
public class DataProduct {
    private static final Logger logger = LoggerFactory.getLogger(DataProduct.class);
    private String productUri;
    private String gatewayId;
    private String productName;
    private String productDescription;
    private String dataProductType;
    private String ownerName;
    private String parentProductUri;
    private int productSize;
    private Timestamp creationTime;
    private Timestamp lastModifiedTime;
    private DataProduct parentDataProduct;
    private Collection<DataReplicaLocation> dataReplicaLocations;
    private Collection<DataProductMetaData> dataProductMetaData;
    private Collection<DataProduct> childDataProducts;

    @Id
    @Column(name="PRODUCT_URI")
    public String getProductUri() {
        return this.productUri;
    }

    public void setProductUri(String productUri) {
        this.productUri = productUri;
    }

    @Column(name="GATEWAY_ID")
    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    @Column(name="PRODUCT_NAME")
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    @Column(name="PRODUCT_DESCRIPTION")
    public String getProductDescription() {
        return this.productDescription;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    @Column(name="OWNER_NAME")
    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Column(name="PARENT_PRODUCT_URI")
    public String getParentProductUri() {
        return this.parentProductUri;
    }

    public void setParentProductUri(String parentProductUri) {
        this.parentProductUri = parentProductUri;
    }

    @Column(name="PRODUCT_TYPE")
    public String getDataProductType() {
        return this.dataProductType;
    }

    public void setDataProductType(String dataProductType) {
        this.dataProductType = dataProductType;
    }

    @Column(name="PRODUCT_SIZE")
    public int getProductSize() {
        return this.productSize;
    }

    public void setProductSize(int productSize) {
        this.productSize = productSize;
    }

    @Column(name="CREATION_TIME")
    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    @Column(name="LAST_MODIFIED_TIME")
    public Timestamp getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Timestamp lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    @OneToMany(mappedBy="dataProduct", cascade={CascadeType.ALL})
    public Collection<DataReplicaLocation> getDataReplicaLocations() {
        return this.dataReplicaLocations;
    }

    public void setDataReplicaLocations(Collection<DataReplicaLocation> dataReplicaLocations) {
        this.dataReplicaLocations = dataReplicaLocations;
    }

    @OneToMany(mappedBy="dataProduct", cascade={CascadeType.ALL})
    public Collection<DataProductMetaData> getDataProductMetaData() {
        return this.dataProductMetaData;
    }

    public void setDataProductMetaData(Collection<DataProductMetaData> dataProductMetaData) {
        this.dataProductMetaData = dataProductMetaData;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="PARENT_PRODUCT_URI", referencedColumnName="PRODUCT_URI")
    public DataProduct getParentDataProduct() {
        return this.parentDataProduct;
    }

    public void setParentDataProduct(DataProduct parentDataProduct) {
        this.parentDataProduct = parentDataProduct;
    }

    @OneToMany(mappedBy="parentDataProduct", cascade={CascadeType.ALL})
    public Collection<DataProduct> getChildDataProducts() {
        return this.childDataProducts;
    }

    public void setChildDataProducts(Collection<DataProduct> childDataProducts) {
        this.childDataProducts = childDataProducts;
    }
}

