#ifndef HIDD_MESAGL_H
#define HIDD_MESAGL_H

/*
    Copyright © 2003, The AROS Development Team. All rights reserved.
    $Id: mesagl.h 24150 2006-03-11 11:21:07Z schulz $
*/

#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif

#ifndef HIDD_HIDD_H
#include <hidd/hidd.h>
#endif

#ifndef OOP_OOP_H
#include <oop/oop.h>
#endif

#include <GL/gl.h>

/* Base I2C class */

#define CLID_Hidd_MesaGL	"hidd.mesagl"
#define IID_Hidd_MesaGL 	"hidd.mesagl"

#define HiddMesaGLAttrBase	__IHidd_MesaGL

#ifndef __OOP_NOATTRBASES__
extern OOP_AttrBase HiddMesaGLAttrBase;
#endif

#define hiddMesaGL_TAG_Dummy           (TAG_USER + 0x32000)
#define hiddMesaGL_TAG_RastPort        (hiddMesaGL_TAG_Dummy + 0x0012)
#define hiddMesaGL_TAG_LeftRastPort    hiddMesaGL_TAG_RastPort
#define hiddMesaGL_TAG_RightRastPort   (hiddMesaGL_TAG_Dummy + 0x0013)
#define hiddMesaGL_TAG_RastVisible     (hiddMesaGL_TAG_Dummy + 0x00cb)
#define hiddMesaGL_TAG_DoubleBuff      (hiddMesaGL_TAG_Dummy + 0x0030)
#define hiddMesaGL_TAG_StereoBuff      (hiddMesaGL_TAG_Dummy + 0x00cc)

#define MAX_SOFT_TEXTURE_COORD_UNITS   8
struct MesaGLRast_Vertex {
    GLfloat                        mglVert_Win[4];
    GLfloat                        mglVert_TexCoord[MAX_SOFT_TEXTURE_COORD_UNITS][4];
    GLubyte                        mglVert_Color[4];
    GLubyte                        mglVert_Specular[4];
    GLfloat                        mglVert_Fog;
    GLfloat                        mglVert_Index;
    GLfloat                        mglVert_PointSize;
};

/** Internal pointers for the RASTERIZERs context data/calls **/
struct MesaGLRast_Context {
    OOP_AttrBase	                 mglRCx_hiddMesaGLRastAB;
    OOP_Class		                 *mglRCx_hiddMesaGLRastClass; /* The rasterizer class we use */
    OOP_Object                     *mglRCx_hiddMesaGLRastObject;
    OOP_MethodID                   mglRCx_meth_CreateRenderBuffer;
    OOP_MethodID                   mglRCx_meth_DestroyRenderBuffer;
    OOP_MethodID                   mglRCx_meth_CreateGLRastPort;
    OOP_MethodID                   mglRCx_meth_DestroyGLRastPort;
    OOP_MethodID                   mglRCx_meth_InitialiseRasterizer;
    OOP_MethodID                   mglRCx_meth_Finish;
    OOP_MethodID                   mglRCx_meth_Flush;
    OOP_MethodID                   mglRCx_meth_Clear;
    OOP_MethodID                   mglRCx_meth_CopyPixels;
    OOP_MethodID                   mglRCx_meth_DrawFlat5R6G5BLine;
    OOP_MethodID                   mglRCx_meth_DrawFlat5R6G5BTriangle;
    OOP_MethodID                   mglRCx_meth_DrawFlat5R6G5BZLine;
    OOP_MethodID                   mglRCx_meth_DrawFlat5R6G5BZTriangle;
    OOP_MethodID                   mglRCx_meth_DrawFlat8A8B8G8RLine;
    OOP_MethodID                   mglRCx_meth_DrawFlat8A8B8G8RTriangle;
    OOP_MethodID                   mglRCx_meth_DrawFlat8A8B8G8RZLine;
    OOP_MethodID                   mglRCx_meth_DrawFlat8A8B8G8RZTriangle;
    OOP_MethodID                   mglRCx_meth_DrawFlat8R8G8B24Line;
    OOP_MethodID                   mglRCx_meth_DrawFlat8R8G8B24Triangle;
    OOP_MethodID                   mglRCx_meth_DrawFlat8R8G8B24ZLine;
    OOP_MethodID                   mglRCx_meth_DrawFlat8R8G8B24ZTriangle;
    OOP_MethodID                   mglRCx_meth_DrawFlat8R8G8BLine;
    OOP_MethodID                   mglRCx_meth_DrawFlat8R8G8BTriangle;
    OOP_MethodID                   mglRCx_meth_DrawFlat8R8G8BZLine;
    OOP_MethodID                   mglRCx_meth_DrawFlat8R8G8BZTriangle;
    OOP_MethodID                   mglRCx_meth_DrawFlatDithered5R6G5BLine;
    OOP_MethodID                   mglRCx_meth_DrawFlatDithered5R6G5BTriangle;
    OOP_MethodID                   mglRCx_meth_DrawFlatDithered5R6G5BZLine;
    OOP_MethodID                   mglRCx_meth_DrawFlatDithered5R6G5BZTriangle;
    OOP_MethodID                   mglRCx_meth_DrawPoints;
    OOP_MethodID                   mglRCx_meth_DrawSmooth5R6G5BTriangle;
    OOP_MethodID                   mglRCx_meth_DrawSmooth5R6G5BZTriangle;
    OOP_MethodID                   mglRCx_meth_DrawSmooth8A8B8G8RTriangle;
    OOP_MethodID                   mglRCx_meth_DrawSmooth8A8B8G8RZTriangle;
    OOP_MethodID                   mglRCx_meth_DrawSmooth8R8G8B24Triangle;
    OOP_MethodID                   mglRCx_meth_DrawSmooth8R8G8B24ZTriangle;
    OOP_MethodID                   mglRCx_meth_DrawSmooth8R8G8BTriangle;
    OOP_MethodID                   mglRCx_meth_DrawSmooth8R8G8BZTriangle;
    OOP_MethodID                   mglRCx_meth_DrawSmoothDithered5R6G5BTriangle;
    OOP_MethodID                   mglRCx_meth_DrawSmoothDithered5R6G5BZTriangle;
    OOP_MethodID                   mglRCx_meth_ReadRGBAPixels;
    OOP_MethodID                   mglRCx_meth_ReadRGBASpan;
    OOP_MethodID                   mglRCx_meth_WriteMonoRGBAPixels;
    OOP_MethodID                   mglRCx_meth_WriteMonoRGBASpan;
    OOP_MethodID                   mglRCx_meth_WriteRGBAPixels;
    OOP_MethodID                   mglRCx_meth_WriteRGBASpan;
    OOP_MethodID                   mglRCx_meth_WriteRGBPixels;
    OOP_MethodID                   mglRCx_meth_WriteRGBSpan;
};

struct MesaGL_hiddRenderBuffer
{
  struct RastPort                  *mglRendBuff_RastPort;
  GLuint                           mglRendBuff_Width;
  GLuint                           mglRendBuff_Height;
};
typedef struct MesaGL_hiddRenderBuffer *hiddMesaGLRenderBuffer;

struct MesaGL_hiddBuffer
{
	IPTR                    gl_buffer;                       /* GLframebuffer* - The depth, stencil, accum, etc buffers */
   UBYTE                   *mglBuff_tmpRenderLine;          /* One Line for WritePixelRow renders */
   hiddMesaGLRenderBuffer  mglBuff_LeftRenderBuffer;        /* Points to BackLeftRenderBuffer normally */
   hiddMesaGLRenderBuffer  mglBuff_RightRenderBuffer;       /* (stereo)  BackRightRenderBuffer normally */  
   hiddMesaGLRenderBuffer  mglBuff_FrontLeftRenderBuffer;
   hiddMesaGLRenderBuffer  mglBuff_FrontRightRenderBuffer;
   hiddMesaGLRenderBuffer  mglBuff_BackLeftRenderBuffer;
   hiddMesaGLRenderBuffer  mglBuff_BackRightRenderBuffer;
   /* your window handle, etc */
};
typedef struct MesaGL_hiddBuffer *hiddMesaGLBuffer;

/**
 * Indexes for all renderbuffers
 */
enum {
   mglVis_BUFFER_FRONT_LEFT  = 0,  /* the four standard color buffers */
   mglVis_BUFFER_BACK_LEFT   = 1,
   mglVis_BUFFER_FRONT_RIGHT = 2,
   mglVis_BUFFER_BACK_RIGHT  = 3,
   mglVis_BUFFER_AUX0        = 4,  /* optional aux buffer */
   mglVis_BUFFER_AUX1        = 5,
   mglVis_BUFFER_AUX2        = 6,
   mglVis_BUFFER_AUX3        = 7,
   mglVis_BUFFER_DEPTH       = 8,
   mglVis_BUFFER_STENCIL     = 9,
   mglVis_BUFFER_ACCUM       = 10,
   mglVis_BUFFER_COLOR0      = 11, /* generic renderbuffers */
   mglVis_BUFFER_COLOR1      = 12,
   mglVis_BUFFER_COLOR2      = 13,
   mglVis_BUFFER_COLOR3      = 14,
   mglVis_BUFFER_COLOR4      = 15,
   mglVis_BUFFER_COLOR5      = 16,
   mglVis_BUFFER_COLOR6      = 17,
   mglVis_BUFFER_COLOR7      = 18,
   mglVis_BUFFER_COUNT       = 19
};

struct MesaGL_hiddVisual
{
   hiddMesaGLBuffer                mglVis_Buffers;
   struct RastPort                 *mglVis_RastPort;        /* Rastport handed in during context creation */

   GLuint                          mglVis_StartX;
   GLuint                          mglVis_StartY;

   /* Internal Details and Flags */
   IPTR                            mglVis_MessageBuffer;
   GLuint                          mglVis_RastDepth;        /* bits per pixel (1, 8, 24, etc)      */
   GLuint                          mglVis_RastWidth;
   GLuint                          mglVis_RastHeight;
   GLuint                          mglVis_ViewWidth;
   GLuint                          mglVis_ViewHeight;
   struct Rectangle                *mglVis_ClipRect;

   GLboolean                       mglVis_FlagVisable;      /* can the mglVis_RastPort actually be seen? */
   GLboolean                       mglVis_FlagDB;           /* double buffered?                          */
   GLboolean                       mglVis_FlagRGB;          /* RGB mode?                                 */
   GLboolean                       mglVis_FlagAlpha;        /* Hardware Alpha?                           */
   GLboolean                       mglVis_FlagFlush;
   GLboolean                       mglVis_FlagFinished;
   
  IPTR                             mglVis_BufferIndexCount;
  IPTR                             mglVis_BufferIndex[mglVis_BUFFER_COUNT];
};
typedef struct MesaGL_hiddVisual *hiddMesaGLVisual;

/**
 * Bit flags for all renderbuffers
 */
#define mglVis_BUFFER_BIT_FRONT_LEFT(vis)   (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_FRONT_LEFT])
#define mglVis_BUFFER_BIT_BACK_LEFT(vis)    (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_BACK_LEFT])
#define mglVis_BUFFER_BIT_FRONT_RIGHT(vis)  (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_FRONT_RIGHT])
#define mglVis_BUFFER_BIT_BACK_RIGHT(vis)   (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_BACK_RIGHT])
#define mglVis_BUFFER_BIT_AUX0(vis)         (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_AUX0])
#define mglVis_BUFFER_BIT_AUX1(vis)         (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_AUX1])
#define mglVis_BUFFER_BIT_AUX2(vis)         (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_AUX2])
#define mglVis_BUFFER_BIT_AUX3(vis)         (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_AUX3])
#define mglVis_BUFFER_BIT_DEPTH(vis)        (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_DEPTH])
#define mglVis_BUFFER_BIT_STENCIL(vis)      (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_STENCIL])
#define mglVis_BUFFER_BIT_ACCUM(vis)        (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_ACCUM])
#define mglVis_BUFFER_BIT_COLOR0(vis)       (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_COLOR0])
#define mglVis_BUFFER_BIT_COLOR1(vis)       (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_COLOR1])
#define mglVis_BUFFER_BIT_COLOR2(vis)       (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_COLOR2])
#define mglVis_BUFFER_BIT_COLOR3(vis)       (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_COLOR3])
#define mglVis_BUFFER_BIT_COLOR4(vis)       (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_COLOR4])
#define mglVis_BUFFER_BIT_COLOR5(vis)       (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_COLOR5])
#define mglVis_BUFFER_BIT_COLOR6(vis)       (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_COLOR6])
#define mglVis_BUFFER_BIT_COLOR7(vis)       (1 << vis->mglVis_BufferIndex[mglVis_BUFFER_COLOR7])

/**
 * Mask of all the color buffer bits (but not accum).
 */
#define mglVis_BUFFER_BITS_COLOR(vis)  (mglVis_BUFFER_BIT_FRONT_LEFT(vis) | \
                                        mglVis_BUFFER_BIT_BACK_LEFT(vis) | \
                                        mglVis_BUFFER_BIT_FRONT_RIGHT(vis) | \
                                        mglVis_BUFFER_BIT_BACK_RIGHT(vis) | \
                                        mglVis_BUFFER_BIT_AUX0(vis) | \
                                        mglVis_BUFFER_BIT_AUX1(vis) | \
                                        mglVis_BUFFER_BIT_AUX2(vis) | \
                                        mglVis_BUFFER_BIT_AUX3(vis) | \
                                        mglVis_BUFFER_BIT_COLOR0(vis) | \
                                        mglVis_BUFFER_BIT_COLOR1(vis) | \
                                        mglVis_BUFFER_BIT_COLOR2(vis) | \
                                        mglVis_BUFFER_BIT_COLOR3(vis) | \
                                        mglVis_BUFFER_BIT_COLOR4(vis) | \
                                        mglVis_BUFFER_BIT_COLOR5(vis) | \
                                        mglVis_BUFFER_BIT_COLOR6(vis) | \
                                        mglVis_BUFFER_BIT_COLOR7(vis))

struct MesaGL_hiddContext {
    struct Node                    mglCx_Node;
    IPTR                           mglCx_Driver;
    OOP_Class		                 *mglCx_hiddMesaGLClass; /* The rasterizer class we use */
    OOP_Object                     *mglCx_hiddMesaGLObject;
    struct MesaGLRast_Context      *mglCx_Rasterizer;
    hiddMesaGLVisual               mglCx_ActiveVisual;
};
typedef struct MesaGL_hiddContext *hiddMesaGLContext;

/* MesaGL Class methods */
enum
{
    moHidd_MesaGL_AddHardwareDriver = 0,
    moHidd_MesaGL_RemHardwareDriver,
    moHidd_MesaGL_CreateContext,
    moHidd_MesaGL_DestroyContext,
    moHidd_MesaGL_CreateBuffers,
    moHidd_MesaGL_DestroyBuffers,
    moHidd_MesaGL_CreateVisual,
    moHidd_MesaGL_DestroyVisual,
    moHidd_MesaGL_MakeCurrent,
    moHidd_MesaGL_SwapBuffers,
    moHidd_MesaGL_RegisterProcFunc,
    moHidd_MesaGL_GetProcAddress,

    NUM_MesaGL_METHODS
};

enum
{
    aoHidd_MesaGL_HoldTime,
    aoHidd_MesaGL_BitTimeout,
    aoHidd_MesaGL_ByteTimeout,
    aoHidd_MesaGL_AcknTimeout,
    aoHidd_MesaGL_StartTimeout,
    aoHidd_MesaGL_RiseFallTime,
    aoHidd_MesaGL_Name,
    
    num_Hidd_MesaGL_Attrs
};

#define aHidd_MesaGL_HoldTime      (HiddMesaGLAttrBase + aoHidd_MesaGL_HoldTime)
#define aHidd_MesaGL_BitTimeout    (HiddMesaGLAttrBase + aoHidd_MesaGL_BitTimeout)
#define aHidd_MesaGL_ByteTimeout   (HiddMesaGLAttrBase + aoHidd_MesaGL_ByteTimeout)
#define aHidd_MesaGL_AcknTimeout   (HiddMesaGLAttrBase + aoHidd_MesaGL_AcknTimeout)
#define aHidd_MesaGL_StartTimeout  (HiddMesaGLAttrBase + aoHidd_MesaGL_StartTimeout)
#define aHidd_MesaGL_RiseFallTime  (HiddMesaGLAttrBase + aoHidd_MesaGL_RiseFallTime)
#define aHidd_MesaGL_Name          (HiddMesaGLAttrBase + aoHidd_MesaGL_Name)

#define IS_MesaGL_ATTR(attr, idx) \
    (((idx) = (attr) - HiddMesaGLAttrBase) < num_Hidd_MesaGL_Attrs)

struct pHidd_MesaGL_AddHardwareDriver
{
    OOP_MethodID      mID;
    OOP_Class		    *mClassParent;        /* ie .. CLID_Hidd_MesaGLRast (or NULL for the base class  */
    OOP_Class		    *mClassFamily;        /* ie .. CLID_Hidd_GeForceMesaGL                           */
    OOP_Class		    *mClassSelf;          /* ie .. CLID_Hidd_GeForceMesaGLRast                       */
};

struct pHidd_MesaGL_RemHardwareDriver
{
    OOP_MethodID      mID;
    OOP_Class		    *mClassSelf;
};

struct pHidd_MesaGL_CreateContext
{
    OOP_MethodID      mID;
    struct TagItem    *mTagList;
};

struct pHidd_MesaGL_DestroyContext
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGL_CreateBuffers
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    hiddMesaGLVisual  mVisual;
};

struct pHidd_MesaGL_DestroyBuffers
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    hiddMesaGLBuffer  mBuffer
};

struct pHidd_MesaGL_CreateVisual
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    struct TagItem    *mTagList
};

struct pHidd_MesaGL_DestroyVisual
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    hiddMesaGLVisual  mVisual;
};

struct pHidd_MesaGL_MakeCurrent
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    hiddMesaGLVisual  mVisual;
};

struct pHidd_MesaGL_SwapBuffers
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGL_RegisterProcFunc
{
    OOP_MethodID      mID;
    IPTR              mHardwareDriver;
    char              *mProcFuncName;
    IPTR              mProcFunc;
};

struct pHidd_MesaGL_GetProcAddress
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    char              *mProcFuncName;
};

/* MesaGLRast device class */

#define CLID_Hidd_MesaGLRast	"hidd.mesagl.rast"
#define IID_Hidd_MesaGLRast 	"hidd.mesagl.rast"

#define HiddMesaGLRastAttrBase	__IHidd_MesaGLRast

#ifndef __OOP_NOATTRBASES__
extern OOP_AttrBase HiddMesaGLRastAttrBase;
#endif

/* MesaGL Class methods */
enum
{
    moHidd_MesaGLRast_CreateRenderBuffer = 0,
    moHidd_MesaGLRast_DestroyRenderBuffer,
    moHidd_MesaGLRast_CreateGLRastPort,
    moHidd_MesaGLRast_DestroyGLRastPort,
    moHidd_MesaGLRast_InitialiseRasterizer,
    moHidd_MesaGLRast_Finish,
    moHidd_MesaGLRast_Flush,
    moHidd_MesaGLRast_Clear = 10,
    moHidd_MesaGLRast_CopyPixels,
    moHidd_MesaGLRast_DrawFlat5R6G5BLine = 20,
    moHidd_MesaGLRast_DrawFlat5R6G5BTriangle,
    moHidd_MesaGLRast_DrawFlat5R6G5BZLine,
    moHidd_MesaGLRast_DrawFlat5R6G5BZTriangle,
    moHidd_MesaGLRast_DrawFlat8A8B8G8RLine,
    moHidd_MesaGLRast_DrawFlat8A8B8G8RTriangle,
    moHidd_MesaGLRast_DrawFlat8A8B8G8RZLine,
    moHidd_MesaGLRast_DrawFlat8A8B8G8RZTriangle,
    moHidd_MesaGLRast_DrawFlat8R8G8B24Line,
    moHidd_MesaGLRast_DrawFlat8R8G8B24Triangle,
    moHidd_MesaGLRast_DrawFlat8R8G8B24ZLine,
    moHidd_MesaGLRast_DrawFlat8R8G8B24ZTriangle,
    moHidd_MesaGLRast_DrawFlat8R8G8BLine,
    moHidd_MesaGLRast_DrawFlat8R8G8BTriangle,
    moHidd_MesaGLRast_DrawFlat8R8G8BZLine,
    moHidd_MesaGLRast_DrawFlat8R8G8BZTriangle,
    moHidd_MesaGLRast_DrawFlatDithered5R6G5BLine,
    moHidd_MesaGLRast_DrawFlatDithered5R6G5BTriangle,
    moHidd_MesaGLRast_DrawFlatDithered5R6G5BZLine,
    moHidd_MesaGLRast_DrawFlatDithered5R6G5BZTriangle,
    moHidd_MesaGLRast_DrawPoints,
    moHidd_MesaGLRast_DrawSmooth5R6G5BTriangle,
    moHidd_MesaGLRast_DrawSmooth5R6G5BZTriangle,
    moHidd_MesaGLRast_DrawSmooth8A8B8G8RTriangle,
    moHidd_MesaGLRast_DrawSmooth8A8B8G8RZTriangle,
    moHidd_MesaGLRast_DrawSmooth8R8G8B24Triangle,
    moHidd_MesaGLRast_DrawSmooth8R8G8B24ZTriangle,
    moHidd_MesaGLRast_DrawSmooth8R8G8BTriangle,
    moHidd_MesaGLRast_DrawSmooth8R8G8BZTriangle,
    moHidd_MesaGLRast_DrawSmoothDithered5R6G5BTriangle,
    moHidd_MesaGLRast_DrawSmoothDithered5R6G5BZTriangle,
    moHidd_MesaGLRast_ReadRGBAPixels,
    moHidd_MesaGLRast_ReadRGBASpan,
    moHidd_MesaGLRast_WriteMonoRGBAPixels,
    moHidd_MesaGLRast_WriteMonoRGBASpan,
    moHidd_MesaGLRast_WriteRGBAPixels,
    moHidd_MesaGLRast_WriteRGBASpan,
    moHidd_MesaGLRast_WriteRGBPixels,
    moHidd_MesaGLRast_WriteRGBSpan,

    NUM_MesaGLRast_METHODS
};

enum
{
    aoHidd_MesaGLRast_HoldTime,
    aoHidd_MesaGLRast_BitTimeout,
    aoHidd_MesaGLRast_ByteTimeout,
    aoHidd_MesaGLRast_AcknTimeout,
    aoHidd_MesaGLRast_StartTimeout,
    aoHidd_MesaGLRast_RiseFallTime,
    aoHidd_MesaGLRast_Name,
    
    num_Hidd_MesaGLRast_Attrs
};

#define aHidd_MesaGLRast_HoldTime      (HiddMesaGLRastAttrBase + aoHidd_MesaGLRast_HoldTime)
#define aHidd_MesaGLRast_BitTimeout    (HiddMesaGLRastAttrBase + aoHidd_MesaGLRast_BitTimeout)
#define aHidd_MesaGLRast_ByteTimeout   (HiddMesaGLRastAttrBase + aoHidd_MesaGLRast_ByteTimeout)
#define aHidd_MesaGLRast_AcknTimeout   (HiddMesaGLRastAttrBase + aoHidd_MesaGLRast_AcknTimeout)
#define aHidd_MesaGLRast_StartTimeout  (HiddMesaGLRastAttrBase + aoHidd_MesaGLRast_StartTimeout)
#define aHidd_MesaGLRast_RiseFallTime  (HiddMesaGLRastAttrBase + aoHidd_MesaGLRast_RiseFallTime)
#define aHidd_MesaGLRast_Name          (HiddMesaGLRastAttrBase + aoHidd_MesaGLRast_Name)

#define IS_MesaGLRast_ATTR(attr, idx) \
    (((idx) = (attr) - HiddMesaGLRastAttrBase) < num_Hidd_MesaGLRast_Attrs)

struct pHidd_MesaGLRast_CreateRenderBuffer
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    GLuint            mWidth;
    GLuint            mHeight;
    GLboolean         mBackBuffer;
};

struct pHidd_MesaGLRast_DestroyRenderBuffer
{
    OOP_MethodID            mID;
    hiddMesaGLContext       mHiddMesaGLCtx;
    hiddMesaGLRenderBuffer  mRenderBuffer;
};

struct pHidd_MesaGLRast_CreateGLRastPort
{
    OOP_MethodID      mID;
    hiddMesaGLVisual  mVisual;
    struct  RastPort  *mFriendRastPort;
    GLboolean         mFlagClone;
};

struct pHidd_MesaGLRast_DestroyGLRastPort
{
    OOP_MethodID      mID;
    struct  RastPort  *mMesaRastPort;
};

struct pHidd_MesaGLRast_InitialiseRasterizer
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGLRast_Finish
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGLRast_Flush
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGLRast_Clear
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    unsigned long     mClearpixel;
    GLbitfield        mMask;
    GLboolean         mAll;
    GLint             mX;
    GLint             mY;
    GLint             mWidth;
    GLint             mHeight;
};

struct pHidd_MesaGLRast_CopyPixels
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    GLint             mSrcX;
    GLint             mSrcY;
    GLint             mWidth;
    GLint             mHeight;
    GLint             mDstX;
    GLint             mDstY;
};

struct pHidd_MesaGLRast_DrawFlat5R6G5BLine
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGLRast_DrawFlat5R6G5BTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawFlat5R6G5BZLine
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGLRast_DrawFlat5R6G5BZTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawFlat8A8B8G8RLine
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGLRast_DrawFlat8A8B8G8RTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawFlat8A8B8G8RZLine
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGLRast_DrawFlat8A8B8G8RZTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawFlat8R8G8B24Line
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    GLuint            mX1;
    GLuint            mY1;
    GLuint            mX2;
    GLuint            mY2;
    GLubyte           *mColor;
};

struct pHidd_MesaGLRast_DrawFlat8R8G8B24Triangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawFlat8R8G8B24ZLine
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    GLuint            mX1;
    GLuint            mY1;
    GLuint            mX2;
    GLuint            mY2;
    GLubyte           *mColor;
};

struct pHidd_MesaGLRast_DrawFlat8R8G8B24ZTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawFlat8R8G8BLine
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGLRast_DrawFlat8R8G8BTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawFlat8R8G8BZLine
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGLRast_DrawFlat8R8G8BZTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawFlatDithered5R6G5BLine
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGLRast_DrawFlatDithered5R6G5BTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawFlatDithered5R6G5BZLine
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGLRast_DrawFlatDithered5R6G5BZTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawPoints
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGLRast_DrawSmooth5R6G5BTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawSmooth5R6G5BZTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawSmooth8A8B8G8RTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawSmooth8A8B8G8RZTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawSmooth8R8G8B24Triangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawSmooth8R8G8B24ZTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawSmooth8R8G8BTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawSmooth8R8G8BZTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawSmoothDithered5R6G5BTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_DrawSmoothDithered5R6G5BZTriangle
{
    OOP_MethodID               mID;
    hiddMesaGLContext          mHiddMesaGLCtx;
    struct MesaGLRast_Vertex   *mVert0;
    struct MesaGLRast_Vertex   *mVert1;
    struct MesaGLRast_Vertex   *mVert2;
};

struct pHidd_MesaGLRast_ReadRGBAPixels
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGLRast_ReadRGBASpan
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
};

struct pHidd_MesaGLRast_WriteMonoRGBAPixels
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    GLuint            mN;
    GLuint            *mX;
    GLuint            *mY;
    GLubyte           *mMask;
    GLubyte           *mColor;
};

struct pHidd_MesaGLRast_WriteMonoRGBASpan
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    GLuint            mN;
    GLuint            mX;
    GLuint            mY;
    GLubyte           *mMask;
    GLubyte           *mColor;
};

struct pHidd_MesaGLRast_WriteRGBAPixels
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    GLuint            mN;
    GLuint            *mX;
    GLuint            *mY;
    GLubyte           *mMask;
    GLubyte           *mRGBA;
};


struct pHidd_MesaGLRast_WriteRGBASpan
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    GLuint            mN;
    GLuint            mX;
    GLuint            mY;
    GLubyte           *mMask;
    GLubyte           *mRGBA;
};

struct pHidd_MesaGLRast_WriteRGBPixels
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    GLuint            mN;
    GLuint            *mX;
    GLuint            *mY;
    GLubyte           *mMask;
    GLubyte           *mRGB;
};

struct pHidd_MesaGLRast_WriteRGBSpan
{
    OOP_MethodID      mID;
    hiddMesaGLContext mHiddMesaGLCtx;
    GLuint            mN;
    GLuint            mX;
    GLuint            mY;
    GLubyte           *mMask;
    GLubyte           *mRGB;
};

#endif
