require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&INLINE4_IFFPARSE_H)) {
    eval 'sub INLINE4_IFFPARSE_H () {1;}' unless defined(&INLINE4_IFFPARSE_H);
    unless(defined(&EXEC_TYPES_H)) {
	require 'exec/types.ph';
    }
    unless(defined(&EXEC_EXEC_H)) {
	require 'exec/exec.ph';
    }
    unless(defined(&EXEC_INTERFACES_H)) {
	require 'exec/interfaces.ph';
    }
    unless(defined(&LIBRARIES_IFFPARSE_H)) {
	require 'libraries/iffparse.ph';
    }
    unless(defined(&UTILITY_HOOKS_H)) {
	require 'utility/hooks.ph';
    }
    eval 'sub AllocIFF () {
        eval q( ($IIFFParse->{AllocIFF})());
    }' unless defined(&AllocIFF);
    eval 'sub OpenIFF {
        local($iff, $rwMode) = @_;
	    eval q( ($IIFFParse->{OpenIFF})($iff, $rwMode));
    }' unless defined(&OpenIFF);
    eval 'sub ParseIFF {
        local($iff, $control) = @_;
	    eval q( ($IIFFParse->{ParseIFF})($iff, $control));
    }' unless defined(&ParseIFF);
    eval 'sub CloseIFF {
        local($iff) = @_;
	    eval q( ($IIFFParse->{CloseIFF})($iff));
    }' unless defined(&CloseIFF);
    eval 'sub FreeIFF {
        local($iff) = @_;
	    eval q( ($IIFFParse->{FreeIFF})($iff));
    }' unless defined(&FreeIFF);
    eval 'sub ReadChunkBytes {
        local($iff, $buf, $numBytes) = @_;
	    eval q( ($IIFFParse->{ReadChunkBytes})($iff, $buf, $numBytes));
    }' unless defined(&ReadChunkBytes);
    eval 'sub WriteChunkBytes {
        local($iff, $buf, $numBytes) = @_;
	    eval q( ($IIFFParse->{WriteChunkBytes})($iff, $buf, $numBytes));
    }' unless defined(&WriteChunkBytes);
    eval 'sub ReadChunkRecords {
        local($iff, $buf, $bytesPerRecord, $numRecords) = @_;
	    eval q( ($IIFFParse->{ReadChunkRecords})($iff, $buf, $bytesPerRecord, $numRecords));
    }' unless defined(&ReadChunkRecords);
    eval 'sub WriteChunkRecords {
        local($iff, $buf, $bytesPerRecord, $numRecords) = @_;
	    eval q( ($IIFFParse->{WriteChunkRecords})($iff, $buf, $bytesPerRecord, $numRecords));
    }' unless defined(&WriteChunkRecords);
    eval 'sub PushChunk {
        local($iff, $type, $id, $size) = @_;
	    eval q( ($IIFFParse->{PushChunk})($iff, $type, $id, $size));
    }' unless defined(&PushChunk);
    eval 'sub PopChunk {
        local($iff) = @_;
	    eval q( ($IIFFParse->{PopChunk})($iff));
    }' unless defined(&PopChunk);
    eval 'sub EntryHandler {
        local($iff, $type, $id, $position, $handler, $object) = @_;
	    eval q( ($IIFFParse->{EntryHandler})($iff, $type, $id, $position, $handler, $object));
    }' unless defined(&EntryHandler);
    eval 'sub ExitHandler {
        local($iff, $type, $id, $position, $handler, $object) = @_;
	    eval q( ($IIFFParse->{ExitHandler})($iff, $type, $id, $position, $handler, $object));
    }' unless defined(&ExitHandler);
    eval 'sub PropChunk {
        local($iff, $type, $id) = @_;
	    eval q( ($IIFFParse->{PropChunk})($iff, $type, $id));
    }' unless defined(&PropChunk);
    eval 'sub PropChunks {
        local($iff, $propArray, $numPairs) = @_;
	    eval q( ($IIFFParse->{PropChunks})($iff, $propArray, $numPairs));
    }' unless defined(&PropChunks);
    eval 'sub StopChunk {
        local($iff, $type, $id) = @_;
	    eval q( ($IIFFParse->{StopChunk})($iff, $type, $id));
    }' unless defined(&StopChunk);
    eval 'sub StopChunks {
        local($iff, $propArray, $numPairs) = @_;
	    eval q( ($IIFFParse->{StopChunks})($iff, $propArray, $numPairs));
    }' unless defined(&StopChunks);
    eval 'sub CollectionChunk {
        local($iff, $type, $id) = @_;
	    eval q( ($IIFFParse->{CollectionChunk})($iff, $type, $id));
    }' unless defined(&CollectionChunk);
    eval 'sub CollectionChunks {
        local($iff, $propArray, $numPairs) = @_;
	    eval q( ($IIFFParse->{CollectionChunks})($iff, $propArray, $numPairs));
    }' unless defined(&CollectionChunks);
    eval 'sub StopOnExit {
        local($iff, $type, $id) = @_;
	    eval q( ($IIFFParse->{StopOnExit})($iff, $type, $id));
    }' unless defined(&StopOnExit);
    eval 'sub FindProp {
        local($iff, $type, $id) = @_;
	    eval q( ($IIFFParse->{FindProp})($iff, $type, $id));
    }' unless defined(&FindProp);
    eval 'sub FindCollection {
        local($iff, $type, $id) = @_;
	    eval q( ($IIFFParse->{FindCollection})($iff, $type, $id));
    }' unless defined(&FindCollection);
    eval 'sub FindPropContext {
        local($iff) = @_;
	    eval q( ($IIFFParse->{FindPropContext})($iff));
    }' unless defined(&FindPropContext);
    eval 'sub CurrentChunk {
        local($iff) = @_;
	    eval q( ($IIFFParse->{CurrentChunk})($iff));
    }' unless defined(&CurrentChunk);
    eval 'sub ParentChunk {
        local($contextNode) = @_;
	    eval q( ($IIFFParse->{ParentChunk})($contextNode));
    }' unless defined(&ParentChunk);
    eval 'sub AllocLocalItem {
        local($type, $id, $ident, $dataSize) = @_;
	    eval q( ($IIFFParse->{AllocLocalItem})($type, $id, $ident, $dataSize));
    }' unless defined(&AllocLocalItem);
    eval 'sub LocalItemData {
        local($localItem) = @_;
	    eval q( ($IIFFParse->{LocalItemData})($localItem));
    }' unless defined(&LocalItemData);
    eval 'sub SetLocalItemPurge {
        local($localItem, $purgeHook) = @_;
	    eval q( ($IIFFParse->{SetLocalItemPurge})($localItem, $purgeHook));
    }' unless defined(&SetLocalItemPurge);
    eval 'sub FreeLocalItem {
        local($localItem) = @_;
	    eval q( ($IIFFParse->{FreeLocalItem})($localItem));
    }' unless defined(&FreeLocalItem);
    eval 'sub FindLocalItem {
        local($iff, $type, $id, $ident) = @_;
	    eval q( ($IIFFParse->{FindLocalItem})($iff, $type, $id, $ident));
    }' unless defined(&FindLocalItem);
    eval 'sub StoreLocalItem {
        local($iff, $localItem, $position) = @_;
	    eval q( ($IIFFParse->{StoreLocalItem})($iff, $localItem, $position));
    }' unless defined(&StoreLocalItem);
    eval 'sub StoreItemInContext {
        local($iff, $localItem, $contextNode) = @_;
	    eval q( ($IIFFParse->{StoreItemInContext})($iff, $localItem, $contextNode));
    }' unless defined(&StoreItemInContext);
    eval 'sub InitIFF {
        local($iff, $flags, $streamHook) = @_;
	    eval q( ($IIFFParse->{InitIFF})($iff, $flags, $streamHook));
    }' unless defined(&InitIFF);
    eval 'sub InitIFFasDOS {
        local($iff) = @_;
	    eval q( ($IIFFParse->{InitIFFasDOS})($iff));
    }' unless defined(&InitIFFasDOS);
    eval 'sub InitIFFasClip {
        local($iff) = @_;
	    eval q( ($IIFFParse->{InitIFFasClip})($iff));
    }' unless defined(&InitIFFasClip);
    eval 'sub OpenClipboard {
        local($unitNumber) = @_;
	    eval q( ($IIFFParse->{OpenClipboard})($unitNumber));
    }' unless defined(&OpenClipboard);
    eval 'sub CloseClipboard {
        local($clipHandle) = @_;
	    eval q( ($IIFFParse->{CloseClipboard})($clipHandle));
    }' unless defined(&CloseClipboard);
    eval 'sub GoodID {
        local($id) = @_;
	    eval q( ($IIFFParse->{GoodID})($id));
    }' unless defined(&GoodID);
    eval 'sub GoodType {
        local($type) = @_;
	    eval q( ($IIFFParse->{GoodType})($type));
    }' unless defined(&GoodType);
    eval 'sub IDtoStr {
        local($id, $buf) = @_;
	    eval q( ($IIFFParse->{IDtoStr})($id, $buf));
    }' unless defined(&IDtoStr);
}
1;
