package Reaction::Classes::Window;

use 5.008005;
use strict;
use warnings;
use Carp;

require Exporter;
use AutoLoader;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration       use Reaction::Classes::Window ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
WindowObject
RA_OpenWindow
RA_CloseWindow
RA_HandleInput
RA_Iconify
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
);

our $VERSION = '0.01';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.

    my $constname;
    our $AUTOLOAD;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "&Reaction::Classes::Window::constant not defined" if $constname eq 'constant';
    my ($error, $val) = constant($constname);
    if ($error) { croak $error; }
    {
        no strict 'refs';
        # Fixed between 5.005_53 and 5.005_61
#XXX    if ($] >= 5.00561) {
#XXX        *$AUTOLOAD = sub () { $val };
#XXX    }
#XXX    else {
            *$AUTOLOAD = sub { $val };
#XXX    }
    }
    goto &$AUTOLOAD;
}

require XSLoader;
XSLoader::load('Reaction::Classes::Window', $VERSION);

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

Reaction::Classes::Window - Perl extension for the Reaction Window Class

=head1 SYNOPSIS

  use Reaction::Classes::Window;

=head1 DESCRIPTION

Stub documentation for Reaction::Classes::Window, created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head2 EXPORT

None by default.

=head2 Exportable constants

  WGUD_FUNC
  WGUD_HOOK
  WGUD_IGNORE
  WINDOW_Activate
  WINDOW_AppMsgHook
  WINDOW_AppPort
  WINDOW_AppWindow
  WINDOW_AppWindowPtr
  WINDOW_Application
  WINDOW_BackFillName
  WINDOW_Dummy
  WINDOW_FrontBack
  WINDOW_GadgetHelp
  WINDOW_GadgetUserData
  WINDOW_HintInfo
  WINDOW_HorizObject
  WINDOW_HorizProp
  WINDOW_IDCMPHook
  WINDOW_IDCMPHookBits
  WINDOW_Icon
  WINDOW_IconNoDispose
  WINDOW_IconTitle
  WINDOW_IconifyGadget
  WINDOW_InputEvent
  WINDOW_InterpretIDCMPHook
  WINDOW_InterpretUserData
  WINDOW_KillWindow
  WINDOW_Layout
  WINDOW_LockHeight
  WINDOW_LockWidth
  WINDOW_MenuStrip
  WINDOW_MenuUserData
  WINDOW_NewMenu
  WINDOW_Parent
  WINDOW_ParentGroup
  WINDOW_ParentLayout
  WINDOW_Position
  WINDOW_PostRefreshHook
  WINDOW_PreRefreshHook
  WINDOW_Qualifier
  WINDOW_RefWindow
  WINDOW_SharedPort
  WINDOW_SigMask
  WINDOW_TextAttr
  WINDOW_UserData
  WINDOW_VertObject
  WINDOW_VertProp
  WINDOW_Window
  WINDOW_Zoom
  WMF_ZIPWINDOW
  WMF_ZOOMED
  WMHI_ACTIVE
  WMHI_CHANGEWINDOW
  WMHI_CLASSMASK
  WMHI_CLOSEWINDOW
  WMHI_DISPOSEDWINDOW
  WMHI_GADGETHELP
  WMHI_GADGETMASK
  WMHI_GADGETUP
  WMHI_ICONIFY
  WMHI_IGNORE
  WMHI_INACTIVE
  WMHI_INTUITICK
  WMHI_KEYMASK
  WMHI_LASTMSG
  WMHI_MENUHELP
  WMHI_MENUMASK
  WMHI_MENUPICK
  WMHI_MOUSEBUTTONS
  WMHI_MOUSEMOVE
  WMHI_NEWSIZE
  WMHI_RAWKEY
  WMHI_UNICONIFY
  WMHI_VANILLAKEY
  WM_ACTIVATEGADGET
  WM_CLOSE
  WM_HANDLEINPUT
  WM_ICONIFY
  WM_NEWPREFS
  WM_OPEN
  WM_RETHINK
  WPOS_CENTERMOUSE
  WPOS_CENTERSCREEN
  WPOS_CENTERWINDOW
  WPOS_FULLSCREEN
  WPOS_TOPLEFT
  WT_BACK
  WT_FRONT



=head1 SEE ALSO

Mention other useful documentation such as the documentation of
related modules or operating system documentation (such as man pages
in UNIX), or any relevant external documentation such as RFCs or
standards.

If you have a mailing list set up for your module, mention it here.

If you have a web site set up for your module, mention it here.

=head1 AUTHOR

A. U. Thor, E<lt>root@nonetE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 by A. U. Thor

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.5 or,
at your option, any later version of Perl 5 you may have available.


=cut
