#!/SDK/Local/C/Perl -w

# This is an example of using the Perl_Reaction GUI interface.
# It's a simple mp3 / id3 tag editor / viewer. It needs the MP3::Info.pm module
# Available at cpan.perl.org and mirrors.

use strict;

# Bring in the Reaction module we need, the names correspond to the equivalent
# C include files in the Amiga OS SDK
# NOTE that we import the tagitem types. TT_#?

# The first "Reaction" provies us with a selecetion of intition and exec functions
# to manipulate our gadgets at the OS level.

use Reaction    qw( :all TT_LONG TT_ULONG TT_APTR TT_STRPTR TT_WORD);

# The next provide Class specific stuff

use Reaction::Classes::Window  ':all';
use Reaction::Gadgets::Button  ':all';
use Reaction::Gadgets::String  ':all';
use Reaction::Gadgets::GetFile ':all';
use Reaction::Gadgets::Layout  ':all';
use Reaction::Gadgets::Integer ':all';
use Reaction::Gadgets::Chooser ':all';
use Reaction::Images::Label    ':all';

# now we must include the .ph files corresponding to the .h files you would
# include in a C program. This gets us all the TAG constants etc.

require "utility/tagitem.ph";
require "reaction/reaction.ph";
require "intuition/intuition.ph";
require "classes/window.ph";
require "gadgets/layout.ph";
require "gadgets/button.ph";
require "gadgets/getfile.ph";
require "gadgets/string.ph";
require "gadgets/integer.ph";
require "gadgets/chooser.ph";
require "images/label.ph";

# Declare our "globals"

use vars qw ( $window $window_obj $artist_string_gad $title_string_gad $album_string_gad
              $genre_chooser_gad $genre_chooser_list $year_integer_gad $comment_string_gad $track_integer_gad
              $getfile_gad $write_button_gad $layout_gad $window_title $write_button_title
              $getfile_title $title_string_label $screen $screen_dri $artist_string_label
              $album_string_label $comment_string_label $year_integer_label $track_integer_label

              $req $id3 );

# This next makes sure that our object gets disposed of in the event of an unexpected
# exit. Say a script error during development or an unexpected bug.


END {
    if($window && $window_obj)
    {
        RA_CloseWindow($window_obj);
        undef $window;
    }
    if($window_obj)
    {
        DisposeObject($window_obj);
    }
    if($genre_chooser_list)
    {
        my $node;
        while ($node = RemHead($genre_chooser_list))
        {
            FreeChooserNode($node);
        }
        FreeList($genre_chooser_list);
        undef $genre_chooser_list;
    }
};


# next include our real work pms
use MP3::Info qw( :DEFAULT :genres);

use_winamp_genres();


# Global strings: Defining them here makes sure they don't "go away". In mant cases
# this doesn't matter but a few gadgets and classes don't make copies of strings.
# Thus you don't want them to be free by perl whilst you are using them!

$window_title = "Mp3 Tag Editor";
$getfile_title = "Select an Mp3 to Edit";
$title_string_label = "Title: ";
$artist_string_label = "Artist: ";
$album_string_label = "Album: ";
$year_integer_label = "Year";
$track_integer_label = "Track: ";
$comment_string_label = "Comment: ";


$write_button_title = "Write Info To Mp3";

# Define GID ids

use constant
{
    GID_ARTIST  => 1,
    GID_TITLE   => 2,
    GID_ALBUM   => 3,
    GID_YEAR    => 4,
    GID_TRACK   => 5,
    GID_COMMENT => 6,
    GID_FILE    => 7,
    GID_WRITE   => 8,
    GID_GENRE   => 9,
};

# Define our GUI functions
#


sub make_window_obj
{
        # The WindowObject() function is from Reaction::Classes:Window and performs the same
        # function as the C Macro. Notice the Entries to the tag arrays have 3 parts not 2
        # as in a classix C tag list, the middle (extra) part is the tagtype it tells perl
        # how to treat the variable. eg as a string or pointer. Without this perl would
        # convert the strings into integers. etc.
        # Notice the tags names and other imported C macros must be prepended with &
        # Last thing to note is because the functions such as LayoutObject() are indeed
        # functions you must include the "(" and ")" in contrast to C where they are macros.

        my $obj = WindowObject(
                        &WA_CloseGadget,&TT_ULONG,&TRUE,
                        &WA_DepthGadget,&TT_ULONG,&TRUE,
                        &WA_SizeGadget,&TT_ULONG,&TRUE,
                        &WA_DragBar,&TT_ULONG,&TRUE,
                        &WA_InnerHeight,&TT_ULONG,200,
                        &WA_InnerWidth,&TT_ULONG,300,
                        &WA_Title,&TT_STRPTR,$window_title,
                        &WA_IDCMP,&TT_ULONG,&IDCMP_RAWKEY|&IDCMP_MENUPICK,
                        &WINDOW_Position, &TT_ULONG, &WPOS_CENTERSCREEN,
                        &WINDOW_LockHeight, &TT_ULONG, &TRUE,
                        &WINDOW_Layout, &TT_APTR, $layout_gad = LayoutObject(
                            &LAYOUT_Orientation, &TT_ULONG, &LAYOUT_ORIENT_VERT,
                            &LAYOUT_SpaceOuter, &TT_ULONG,&TRUE,
                            &LAYOUT_AddChild, &TT_APTR, $getfile_gad = GetFileObject(
                                &GA_ID,&TT_ULONG, GID_FILE,
                                &GA_RelVerify, &TT_ULONG, &TRUE,
                                &GETFILE_FullFileExpand,&TT_ULONG,&TRUE,
                                &GETFILE_TitleText,&TT_STRPTR,$getfile_title,
                                &GETFILE_ReadOnly, &TT_ULONG, &TRUE,
                                &TAG_DONE),
                            &LAYOUT_AddChild, &TT_APTR, $title_string_gad = StringObject(
                                &STRINGA_MaxChars, &TT_ULONG, 30,
                                &GA_ID, &TT_ULONG, GID_TITLE,
                                &GA_TabCycle,&TT_ULONG, &TRUE,
                                &TAG_DONE),
                            &CHILD_Label,&TT_APTR,LabelObject(
                                &LABEL_DrawInfo, &TT_APTR, $screen_dri,
                                &LABEL_Text, &TT_STRPTR, $title_string_label,
                                &TAG_DONE),
                            &LAYOUT_AddChild, &TT_APTR, $artist_string_gad = StringObject(
                                &STRINGA_MaxChars, &TT_ULONG, 30,
                                &GA_ID, &TT_ULONG, GID_ARTIST,
                                &GA_TabCycle,&TT_ULONG, &TRUE,
                                &TAG_DONE),
                            &CHILD_Label,&TT_APTR,LabelObject(
                                &LABEL_DrawInfo, &TT_APTR, $screen_dri,
                                &LABEL_Text, &TT_STRPTR, $artist_string_label,
                                &TAG_DONE),
                            &LAYOUT_AddChild, &TT_APTR, $album_string_gad = StringObject(
                                &STRINGA_MaxChars, &TT_ULONG, 30,
                                &GA_ID, &TT_ULONG, GID_ALBUM,
                                &GA_TabCycle,&TT_ULONG, &TRUE,
                                &TAG_DONE),
                            &CHILD_Label,&TT_APTR,LabelObject(
                                &LABEL_DrawInfo, &TT_APTR, $screen_dri,
                                &LABEL_Text, &TT_STRPTR, $album_string_label,
                                &TAG_DONE),
                            &LAYOUT_AddChild, &TT_APTR, $track_integer_gad = IntegerObject(
                                &INTEGER_MaxChars, &TT_ULONG, 3,
                                &INTEGER_Minimum, &TT_LONG, 0,
                                &INTEGER_Maximum, &TT_LONG, 255,
                                &INTEGER_MinVisible, &TT_ULONG, 1,
                                &GA_ID, &TT_ULONG, GID_TRACK,
                                &GA_TabCycle,&TT_ULONG, &TRUE,
                                &TAG_DONE),
                            &CHILD_Label,&TT_APTR,LabelObject(
                                &LABEL_DrawInfo, &TT_APTR, $screen_dri,
                                &LABEL_Text, &TT_STRPTR, $track_integer_label,
                                &TAG_DONE),
                            &LAYOUT_AddChild, &TT_APTR, $year_integer_gad = IntegerObject(
                                &INTEGER_MaxChars, &TT_ULONG, 4,
                                &INTEGER_Minimum, &TT_LONG, 0,
                                &INTEGER_MinVisible, &TT_ULONG, 4,
                                &GA_ID, &TT_ULONG, GID_YEAR,
                                &GA_TabCycle,&TT_ULONG, &TRUE,
                                &TAG_DONE),
                            &CHILD_Label,&TT_APTR,LabelObject(
                                &LABEL_DrawInfo, &TT_APTR, $screen_dri,
                                &LABEL_Text, &TT_STRPTR, $year_integer_label,
                                &TAG_DONE),
                            &LAYOUT_AddChild, &TT_APTR, $genre_chooser_gad = ChooserObject(
                                &GA_ID, &TT_ULONG, GID_GENRE,
                                &GA_TabCycle,&TT_ULONG, &TRUE,
                                &CHOOSER_Labels, &TT_APTR, $genre_chooser_list,
                                &CHOOSER_MaxLabels, &TT_WORD, $#mp3_genres + 1,
                                &TAG_DONE),
                            &LAYOUT_AddChild, &TT_APTR, $comment_string_gad = StringObject(
                                &STRINGA_MaxChars, &TT_ULONG, 28,
                                &GA_ID, &TT_ULONG, GID_COMMENT,
                                &GA_TabCycle,&TT_ULONG, &TRUE,
                                &TAG_DONE),
                            &CHILD_Label,&TT_APTR,LabelObject(
                                &LABEL_DrawInfo, &TT_APTR, $screen_dri,
                                &LABEL_Text, &TT_STRPTR, $comment_string_label,
                                &TAG_DONE),
                            &LAYOUT_AddChild,&TT_APTR, $write_button_gad = ButtonObject(
                                &GA_Text, &TT_STRPTR, $write_button_title,
                                &GA_ID, &TT_ULONG, GID_WRITE,
                                &GA_RelVerify, &TT_ULONG, &TRUE,
                                &TAG_DONE),
                            &CHILD_WeightedHeight,&TT_ULONG,0,
                            &TAG_DONE),
                        &TAG_DONE);
       $obj;
}

sub make_genre_chooser_list
{
    # Build and return a list of chooser nodes;
    my $list = AllocList();
    my $node;
    # AllocList uses AllocSystemObject so no need to call NewList
    if ($list)
    {
        my $g;
        foreach $g (@mp3_genres)
        {
            $node = AllocChooserNode(&CNA_Text,&TT_STRPTR, $g, &TAG_DONE);
            AddTail($list, $node) if $node;
        }
    }
    $list;
}

sub handle_window_input
{
    my $result;
    my $code;
    my $die = 0;

    # Notice RA_HandleInput() returns a list in contrast to the C macro which puts
    # code in a pointer to a variable, well this perl after all!

    HI:
    while ((($result, $code) = RA_HandleInput($window_obj)) && $result != &WMHI_LASTMSG)
    {
        SWITCHCLASS:
        {
            (($result & &WMHI_CLASSMASK) == &WMHI_CLOSEWINDOW)  and do
            {
                $die = 1;
                last SWITCHCLASS;
            };

            (($result & &WMHI_CLASSMASK) == &WMHI_GADGETUP)    and do
            {
                SWITCHGADGET:
                {
                    my $gid = ($result & &WMHI_GADGETMASK);
                    ($gid == GID_FILE) and do
                    {

                        # This prevents perl griping about the unitilised variable $file
                        # when we pass it to GetAttr(). Alternative we could preset $file = 0;

                        no warnings;

                        my $filename;
                        my $filevalid = IDoMethod($getfile_gad, &GFILE_REQUEST, $window);

                        # If filevalid is true we get the GETFILE_FullFile attribute from the
                        # GetFile gadget. Note that we have an extra arg compared with the C function, that
                        # is the tagtype. In this case we ensure that we get a string returned.

                        $filevalid and GetAttr(&GETFILE_FullFile, $getfile_gad, &TT_STRPTR, $filename);

                        # We've set the file requester to produce absolute paths so we can
                        # do a simple to amiga to unix conversion using a regexp. This may not
                        # allways be necessary, some modules can "eat" amigaos paths some can't.

                        if($filename)
                        {
                            $filename =~ s/(.*):(.*)/\/$1\/$2/;
                            $id3 = MP3::Info->new($filename);
                            if($id3)
                            {
                                # Update our gadgets;
                                SetGadgetAttrs($title_string_gad,$window,$req,&STRINGA_TextVal,&TT_STRPTR,$id3->TITLE,&TAG_DONE);
                                SetGadgetAttrs($artist_string_gad,$window,$req,&STRINGA_TextVal,&TT_STRPTR,$id3->ARTIST,&TAG_DONE);
                                SetGadgetAttrs($album_string_gad,$window,$req,&STRINGA_TextVal,&TT_STRPTR,$id3->ALBUM,&TAG_DONE);
                                SetGadgetAttrs($year_integer_gad,$window,$req,&INTEGER_Number,&TT_ULONG,$id3->YEAR,&TAG_DONE);
                                SetGadgetAttrs($track_integer_gad,$window,$req,&INTEGER_Number,&TT_ULONG,$id3->TRACKNUM,&TAG_DONE);
                                SetGadgetAttrs($comment_string_gad,$window,$req,&STRINGA_TextVal,&TT_STRPTR,$id3->COMMENT,&TAG_DONE);
                                SetGadgetAttrs($genre_chooser_gad,$window,$req,&CHOOSER_Selected, &TT_WORD,$mp3_genres{$id3->GENRE},&TAG_DONE);
                                # Enable the "Write To Mp3 Button";
                                RefreshSetGadgetAttrs($write_button_gad,$window,$req,&GA_Disabled,&TT_ULONG, &FALSE, &TAG_DONE);
                            }
                            else
                            {
                                print "Not an mp3 file\n";
                                # Disable the write to mp3 button in case we don't have an mp3!
                                RefreshSetGadgetAttrs($write_button_gad,$window,$req,&GA_Disabled,&TT_ULONG, &TRUE, &TAG_DONE);

                            }
                        }

                        last SWITCHGADGET;
                    };
                    ($gid == GID_WRITE) and do
                    {
                        my $value="0";

                        GetAttr(&STRINGA_TextVal,$artist_string_gad,&TT_STRPTR,$value);
                        $id3->ARTIST($value);

                        GetAttr(&STRINGA_TextVal,$album_string_gad,&TT_STRPTR,$value);
                        $id3->ALBUM($value);

                        GetAttr(&STRINGA_TextVal,$title_string_gad,&TT_STRPTR,$value);
                        $id3->TITLE($value);

                        GetAttr(&STRINGA_TextVal,$comment_string_gad,&TT_STRPTR,$value);
                        $id3->COMMENT($value);

                        $value = 0;

                        GetAttr(&INTEGER_Number,$year_integer_gad,&TT_ULONG,$value);
                        $id3->YEAR($value);

                        GetAttr(&INTEGER_Number,$track_integer_gad,&TT_ULONG,$value);
                        $id3->TRACKNUM($value);

                        GetAttr(&CHOOSER_Selected, $genre_chooser_gad, &TT_ULONG, $value);
                        $id3->GENRE("$mp3_genres[$value]");

                        last SWITCHGADGET;
                    };
                }
                last SWITCHCLASS;
            };
            (($result & &WMHI_CLASSMASK) == &WMHI_MENUPICK)      and do
            {
                #if we had a menu it would be process here!
                last SWITCHCLASS;
            };
        }
    }
    $die;
}

# The next batch of function do our real work...



# Finally the main loop

# A lot of gadget function need the requester but will complain if we pass a constant
# so use a variable and set it to 0.

$req = 0;

# We need to get the DrawInfo from our screen.

$screen = LockPubScreen("Workbench");
if($screen)
{
    $screen_dri = GetScreenDrawInfo($screen);
    UnlockPubScreen($screen);

    # build our chooser list;

    last unless $genre_chooser_list = make_genre_chooser_list();

    # Create out window object

    if($window_obj = make_window_obj())
    {
        # Open the window
        if($window = RA_OpenWindow($window_obj))
        {

            # Now we need to get th windows signal flag
            my $res;
            my $sigflag = 0;
            my $sig;
            $res = Reaction::GetAttr(&WINDOW_SigMask, $window_obj, &TT_ULONG, $sigflag);
            if($res)
            {
                # The result was valid therefor we can Wait on the value of $sigflag
                QUITLOOP:
                while(1)
                {
                    $sig = Wait($sigflag);
                    if($sig & $sigflag)
                    {
                        last QUITLOOP if handle_window_input;
                    }

                }
            }

            RA_CloseWindow($window_obj);
            undef $window;
        }

        # Dispose our WindowObject and undef the variable holding it.
        # If we don't our END block above will double dispose it, not nice ....

        DisposeObject($window_obj);
        undef $window_obj;
    }
    if($screen_dri)
    {
        FreeScreenDrawInfo($screen,$screen_dri);
        undef $screen_dri;
    }
}
