#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "../tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/gadtools.h>
#include <libraries/gadtools.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}

typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}


MODULE = Reaction::Menu              PACKAGE = Reaction::Menu

PROTOTYPES: DISABLE

APTR
CreateMenus(newmenu, tags, ...)
    APTR newmenu;
    TagList *tags;
    CODE:
        RETVAL = IGadTools->CreateMenusA((struct NewMenu *)newmenu, (struct TagItem *) tags);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);


void
FreeMenus(menus)
    APTR menus;
    CODE:
        IGadTools->FreeMenus((struct Menu *)menus);



APTR
GetVisualInfo(screen)
    APTR screen;
    CODE:
        RETVAL = IGadTools->GetVisualInfo((struct Screen *)screen,TAG_DONE);
    OUTPUT:
        RETVAL


void
FreeVisualInfo(vi)
    APTR vi;
    CODE:
        IGadTools->FreeVisualInfo(vi);


BOOL
LayoutMenus(menu, vi, tags, ...)
    APTR menu;
    APTR vi;
    TagList *tags;
    CODE:
        RETVAL = IGadTools->LayoutMenusA((struct Menu *)menu, vi, (struct TagItem *)tags);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);


BOOL
LayoutMenuItems(menuitem, vi, tags, ...)
    APTR menuitem;
    APTR vi;
    TagList *tags;
    CODE:
        RETVAL = IGadTools->LayoutMenuItemsA((struct MenuItem *)menuitem, vi, (struct TagItem *)tags);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);



APTR
MakeNewMenuArray(num, ...)
    LONG num;
    CODE:
        {
            struct NewMenu *nm = NULL;
            int i;
            if(num == (items -1) / 6)
            {
                if((nm = IExec->AllocVec((num * sizeof(struct NewMenu)),MEMF_CLEAR|MEMF_ANY)))
                {
                    for(i = 0; i < num; i++)
                    {
                        nm[i].nm_Type    = (UBYTE)SvUV(ST((i * 6)+1));
                        nm[i].nm_Label   = (STRPTR)SvPV_nolen(ST((i * 6) +2));
                        nm[i].nm_CommKey = (STRPTR)SvPV_nolen(ST((i * 6) +3));
                        if(nm[i].nm_CommKey && (strlen(nm[i].nm_CommKey) == 0))
                        {
                            nm[i].nm_CommKey = NULL;
                        }
                        nm[i].nm_Flags   = (UWORD)SvUV(ST((i * 6) +4));
                        nm[i].nm_MutualExclude = (ULONG)SvUV(ST((i * 6) +5));
                        nm[i].nm_UserData = (APTR)INT2PTR(APTR,SvIV(ST((i * 6) + 6)));
                    }
                }
            }
            else
            {
                Perl_croak(aTHX_ "MakeNewMenuArray called with wrong number of arguments");
            }
            RETVAL = nm;
        }
    OUTPUT:
        RETVAL


void
FreeNewMenuArray(newmenu)
    APTR newmenu;
    CODE:
        IExec->FreeVec(newmenu);



LONG
GetMenuItemUserData(menu, num)
    APTR menu;
    UWORD num;
    CODE:
        {
            struct MenuItem *mi = IIntuition->ItemAddress((struct Menu *)menu, num);
            RETVAL = GTMENUITEM_USERDATA(mi);
        }
     OUTPUT:
        RETVAL



