#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/layout.h>
#include <gadgets/layout.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}

typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}

MODULE = Reaction::Gadgets::Layout              PACKAGE = Reaction::Gadgets::Layout

PROTOTYPES: DISABLE

APTR
LayoutObject(taglist, ...)
    TagList * taglist;
    CODE:
        RETVAL = IIntuition->NewObjectA(ILayout->LAYOUT_GetClass(),NULL,(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);


APTR
PageObject(taglist, ...)
    TagList * taglist;
    CODE:
        RETVAL = IIntuition->NewObjectA(ILayout->PAGE_GetClass(),NULL,(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);


BOOL
ActivateLayoutGadget(gad, win, req, obj)
    APTR gad;
    APTR win;
    APTR req;
    APTR obj;
    CODE:
        RETVAL = ILayout->ActivateLayoutGadget(gad,win,req,obj);
    OUTPUT:
        RETVAL

void
FlushLayoutDomainCache(gad)
    APTR gad;
    CODE:
        ILayout->FlushLayoutDomainCache(gad);

void
LayoutLimits(layout, font, screen)
    APTR layout;
    APTR font;
    APTR screen;
    PREINIT:
       int minw;
       int minh;
       int maxw;
       int maxh;
    PPCODE:
        {
            struct LayoutLimits l;
            ILayout->LayoutLimits(layout,&l,font,screen);
            minw = (int)l.MinWidth;
            minh = (int)l.MinHeight;
            maxw = (int)l.MaxWidth;
            maxh = (int)l.MaxHeight;
            EXTEND(SP,4);
            PUSHs(sv_2mortal(newSViv(minw)));
            PUSHs(sv_2mortal(newSViv(minh)));
            PUSHs(sv_2mortal(newSViv(maxw)));
            PUSHs(sv_2mortal(newSViv(maxh)));

        }


void
RethinkLayout(layout, window, requester, refresh)
    APTR layout;
    APTR window;
    APTR requester;
    BOOL refresh;
    CODE:
        ILayout->RethinkLayout(layout, window, requester, refresh);


void
RefreshPageGadget(gad, page, win ,req)
    APTR gad;
    APTR page;
    APTR win;
    APTR req;
    CODE:
        ILayout->RefreshPageGadget(gad,page,win,req);


ULONG
SetPageGadgetAttrs(gad, page ,win ,req, tags, ...)
    APTR gad;
    APTR page;
    APTR win;
    APTR req;
    TagList *tags;
    CODE:
        RETVAL = ILayout->SetPageGadgetAttrsA(gad, page, win, req, tags);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);


