#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/getfont.h>
#include <gadgets/getfont.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}

typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}


MODULE = Reaction::Gadgets::GetFont              PACKAGE = Reaction::Gadgets::GetFont

PROTOTYPES: DISABLE

APTR
GetFontObject(taglist, ...)
    TagList * taglist
    CODE:
        RETVAL = IIntuition->NewObjectA(IGetFont->GETFONT_GetClass(),NULL,(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);
