#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/datebrowser.h>
#include <gadgets/datebrowser.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}

typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}


MODULE = Reaction::Gadgets::DateBrowser              PACKAGE = Reaction::Gadgets::DateBrowser

PROTOTYPES: DISABLE

APTR
DateBrowserObject(taglist, ...)
    TagList * taglist
    CODE:
        RETVAL = IIntuition->NewObjectA(IDateBrowser->DATEBROWSER_GetClass(),NULL,(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);

WORD
JulianMonthDays(month, year)
    WORD month;
    LONG year;
    CODE:
        RETVAL = IDateBrowser->JulianMonthDays(month ,year);
    OUTPUT:
        RETVAL


BOOL
JulianLeapYear(year)
    LONG year;
    CODE:
        RETVAL = IDateBrowser->JulianLeapYear(year);
    OUTPUT:
        RETVAL


WORD
JulianWeekDay(day,month,year)
    WORD day;
    WORD month;
    LONG year;
    CODE:
        RETVAL = IDateBrowser->JulianWeekDay(day, month, year);
    OUTPUT:
        RETVAL



