#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/colorwheel.h>
#include <gadgets/colorwheel.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}

typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}


MODULE = Reaction::Gadgets::ColorWheel              PACKAGE = Reaction::Gadgets::ColorWheel

PROTOTYPES: DISABLE

APTR
ColorWheelObject(taglist, ...)
    TagList * taglist
    CODE:
        RETVAL = IIntuition->NewObjectA(NULL,"colorwheel.gadget",(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);


void
ConvertHSBToRGB(hsb,rgb)
        APTR hsb;
        APTR rgb;
        CODE:
            IColorWheel->ConvertHSBToRGB((struct ColorWheelHSB *)hsb, (struct ColorWheelRGB *)rgb);


void
ConvertRGBToHSB(rgb,hsb)
        APTR hsb;
        APTR rgb;
        CODE:
            IColorWheel->ConvertRGBToHSB((struct ColorWheelRGB *)rgb, (struct ColorWheelHSB *)hsb);



void
ReadColor(rgb)
    APTR rgb;
    PPCODE:
        {
            EXTEND(SP,3);
            PUSHs(sv_2mortal(newSViv( ((struct ColorWheelRGB *)rgb)->cw_Red )));
            PUSHs(sv_2mortal(newSViv( ((struct ColorWheelRGB *)rgb)->cw_Green )));
            PUSHs(sv_2mortal(newSViv( ((struct ColorWheelRGB *)rgb)->cw_Blue )));
        }

void
WriteColor(rgb,r,g,b)
    APTR rgb;
    ULONG r;
    ULONG g;
    ULONG b;
    CODE:
        ((struct ColorWheelRGB *)rgb)->cw_Red = r;
        ((struct ColorWheelRGB *)rgb)->cw_Green = g;
        ((struct ColorWheelRGB *)rgb)->cw_Blue = b;


APTR
AllocColor()
    PREINIT:
    struct ColorWheelRGB *ptr;
    CODE:
        New(0,ptr,1,struct ColorWheelRGB);
        RETVAL = ptr;
    OUTPUT:
        RETVAL


void
FreeColor(ptr)
    APTR ptr;
    CODE:
        Safefree(ptr);


