#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"
#include "tagtypes.h"

#undef __USE_INLINE__
#include <exec/types.h>
#include <utility/tagitem.h>
#include <proto/exec.h>
#include <proto/intuition.h>
#include <proto/chooser.h>
#include <gadgets/chooser.h>

typedef int intArray; /* T_ARRAY */

intArray * intArrayPtr( int nelem ) {
    intArray * array;
    New(0, array, nelem, intArray);
    return array;
}

typedef struct TagItem TagList; /* T_TAGLIST */

TagList * TagListPtr( int nelem ) {
    TagList * array;
    New(0, array, (nelem / 3) +1 , TagList);
    return array;
}


MODULE = Reaction::Gadgets::Chooser              PACKAGE = Reaction::Gadgets::Chooser

PROTOTYPES: DISABLE

APTR
ChooserObject(taglist, ...)
    TagList * taglist
    CODE:
        RETVAL = IIntuition->NewObjectA(IChooser->CHOOSER_GetClass(),NULL,(struct TagItem *)taglist);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(taglist);


APTR
AllocChooserNode(tags,...)
    TagList * tags;
    CODE:
        RETVAL = IChooser->AllocChooserNodeA(tags);
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);


void
FreeChooserNode(node)
    APTR node;
    CODE:
        IChooser->FreeChooserNode(node);


void
SetChooserNodeAttrs(node, tags, ...)
    APTR node;
    TagList *tags;
    CODE:
        IChooser->SetChooserNodeAttrsA(node, tags);


intArray *
GetChooserNodeAttrs(node, tags, ...)
    APTR node;
    intArray *tags;
    PREINIT:
        U32 size_RETVAL;
    CODE:
        IChooser->GetChooserNodeAttrsA(node, tags);
        size_RETVAL = ix_tags;
        RETVAL = tags;
    OUTPUT:
        RETVAL
    CLEANUP:
        Safefree(tags);
        XSRETURN(size_RETVAL);


void
GetChooserNodeAttr(tag, node, tagtype, value)
    ULONG tag;
    APTR  node;
    ULONG tagtype;
    TAGRET &value;
    CODE:
        IChooser->GetChooserNodeAttrs(node, tag, &value, TAG_DONE);
    OUTPUT:
        value



